#include "../libc/types.h"
#include "typedefs.h"
#include "config.h"
#include "bitpump.h"
#include "util.h"

/***********************************************************/
/*    _FfeReverse()                                        */
/*                                                         */
/*    returns: true if reversed, false otherwise           */
/*                                                         */
/*    Input variables: BP_U_8BIT no;                       */
/*                                                         */
/*    Output variables: None                               */
/*                                                         */
/*    example:                                             */
/*                                                         */
/* Programmer:                                             */
/*     iris shuker                09-May-1995              */
/*                                                         */
/* revision history:                                       */
/*                                                         */
/***********************************************************/
_FfeReverse()
{
    u_char ffedata[2];
    BP_S_16BIT temp_value, max_value;
    BP_U_8BIT index;


    /*---------------------*/
    /* Find FFE main tap   */
    /*---------------------*/
    max_value = 0;
    for (index = 4; index < 8; index++) {
	bp_eq_read(index, ffedata);
        temp_value = (BP_S_16BIT) BYTE2WORD(ffedata[1], ffedata[0]);
        if (abs(temp_value) > abs(max_value))
            max_value = temp_value;
    } /* END FOR */

    /*---------------------*/
    /* FFE reverse         */
    /*---------------------*/
    if (max_value < 0) { /* FFE main tap negative */
#ifdef TDEBUG
        printf("FFE reversal of fortune!\r\n");
#endif
        for (index = 0; index < 8; index++) {
	    bp_eq_read(index, ffedata);
            temp_value = (BP_S_16BIT) BYTE2WORD(ffedata[1], ffedata[0]);
            temp_value = -temp_value;
	    ffedata[0] = LOW(temp_value);
	    ffedata[1] = HIGH(temp_value);
	    bp_eq_write(index, ffedata);
        } /* END FOR */
	return(1);
    } else
	return(0);

} /* END _FfeReverse() */


/***********************************************************/
/*    _ShiftFfe()                                          */
/*                                                         */
/*    returns: true if shift was made, false otherwise     */
/*                                                         */
/*    Input variables: BP_U_8BIT no;                       */
/*                                                         */
/*    Output variables: None                               */
/*                                                         */
/*    example:                                             */
/*                                                         */
/* Programmer:                                             */
/*     iris shuker                09-May-1995              */
/*                                                         */
/* revision history:                                       */
/*                                                         */
/***********************************************************/
_ShiftFfe()
{
    BP_U_8BIT index, main_tap;
    BP_S_8BIT temp, temp1;
    BP_S_16BIT max_value, temp_value;
    u_char ffedata[2];

    /*-------------------*/
    /* Find FFE main tap */
    /*-------------------*/
    max_value = 0;
    main_tap = 0;
    for (index = 0; index < 8; index++) {
	bp_eq_read(index, ffedata);
        temp_value = (BP_S_16BIT) BYTE2WORD(ffedata[1], ffedata[0]);
        if (abs(temp_value) > abs(max_value)) {
            max_value = temp_value;
            main_tap = index;
        } /* END IF */
    } /* END FOR */

    /*-----------*/
    /* Shift FFE */
    /*-----------*/
    if (main_tap == 7) {
        for (index=2; index<8; index++) {
	    bp_eq_read(index, ffedata);
	    bp_eq_write(index-2, ffedata);
        } /* End for */
	ffedata[0] = ffedata[1] = 0;
        for (index=6; index<8; index++)
	    bp_eq_write(index, ffedata);
	return(1);
    } else
	return(0);

} /* End _ShiftFfe() */

/*
 * On the HTU-R we multiply all FFE coefficients by 1.25 via
 * _ScaleFfe125() and nothing more, but on the HTU-C we also
 * make the opposite adjustment to DAGC: multiply it by 0.875.
 */
void
_ScaleDagc0875()
{
	BP_S_16BIT temp_p;
	u_char bytes[2];

	bp_eq_read(DAGC_HIGH, bytes);
	temp_p = (BP_S_16BIT) BYTE2WORD(bytes[1], bytes[0]);
	temp_p = temp_p - (temp_p>>3);  /* multiply by 0.875 */ 
	bytes[0] = LOW(temp_p);
	bytes[1] = HIGH(temp_p);
	bp_eq_write(DAGC_HIGH, bytes);
}

/***********************************************************/
/*    _ScaleFfe125()                                       */
/*                                                         */
/*    returns: nothing                                     */
/*                                                         */
/*    Input variables: BP_U_8BIT no;                       */
/*                                                         */
/*    Output variables: None                               */
/*                                                         */
/*    example:                                             */
/*                                                         */
/* Programmer:                                             */
/*     Dean Rasmussen             18-Feb-1997              */
/*                                                         */
/* revision history:                                       */
/*                                                         */
/***********************************************************/
void
_ScaleFfe125()
{
    BP_U_8BIT index;
    BP_S_16BIT temp_p;
    u_char ffedata[2];

    /* Scale FFE Coefficient values by 1.25 */ 

    for (index=0; index<8; index++) {
	bp_eq_read(index, ffedata);
        temp_p = (BP_S_16BIT) BYTE2WORD(ffedata[1], ffedata[0]);
        temp_p += (temp_p >> 2);
	ffedata[0] = LOW(temp_p);
	ffedata[1] = HIGH(temp_p);
	bp_eq_write(index, ffedata);
    }
}
