/*
 * Table for deducing the dB attenuation from the FELM
 * The table and the associated logic copied directly from ZipWire
 */

#include "../libc/types.h"
#include "typedefs.h"
#include "bpstate.h"
#include "util.h"

#define _FELM_NUM_DATA_RATES        8

/*
 * Based on 13.5dB transmitted power.  Calibrated to match 150k Sine Wave
 * Attenuation
 */
static const BP_TABLE felm_to_db_table[_FELM_NUM_DATA_RATES][TABLE_LENGTH] = {
    /* 144kbps */
{   5708, 5356, 5025, 4714, 4421, 4147, 3890, 3649, 3423, 3212, 3014,
    2830, 2658, 2498, 2348, 2209, 2079, 1958, 1845, 1741, 1643, 1552,
    1467, 1388, 1314, 1245, 1181, 1120, 1063, 1009, 958, 909, 863, 820,
    778, 737, 699, 661, 625, 590, 556, 523, 491, 459, 429, 399, 371,
    344, 317, 292, 269, 247, 226, 208, 192, 179, 168, 161, 156, 141, 131,
    120, 110, 100},
    /* 272kbps */
{   6314, 5909, 5527, 5167, 4828, 4509, 4209, 3928, 3664, 3417, 3185,
    2969, 2767, 2578, 2402, 2238, 2086, 1944, 1813, 1691, 1577, 1472,
    1375, 1285, 1202, 1125, 1054, 988, 926, 870, 817, 768, 723, 680,
    640, 603, 568, 535, 504, 475, 446, 420, 394, 369, 346, 323, 302,
    281, 261, 242, 224, 207, 191, 177, 164, 152, 142, 134, 128, 125, 124,
    109, 102, 97},
    /* 400kbps */
{   6080, 5653, 5252, 4876, 4524, 4194, 3887, 3600, 3332, 3083,
    2852, 2637, 2439, 2255, 2084, 1928, 1783, 1650, 1528, 1415, 1312, 1218,
    1132, 1053, 980, 914, 854, 799, 748, 702, 659, 620, 583, 550,
    518, 489, 461, 435, 410, 386, 363, 341, 319, 298, 278, 258, 238, 220,
    201, 184, 167, 151, 136, 123, 111, 101, 93, 87, 84, 84, 74, 69, 63, 59},
    /* 528kbps */
{   6159, 5704, 5278, 4879, 4507, 4160, 3837, 3537, 3258, 2999, 2760,
    2539, 2335, 2147, 1975, 1816, 1671, 1538, 1417, 1306, 1206, 1114,
    1031, 956, 887, 825, 769, 718, 672, 630, 592, 556, 524, 494,
    466, 440, 416, 393, 370, 349, 328, 307, 288, 268, 249, 229, 211, 192,
    174, 157, 140, 125, 110, 97, 85, 76, 68, 64, 62, 56, 52, 47, 43, 40},
    /* 784kbps */
{   6132, 5647, 5194, 4773, 4380, 4016, 3678, 3366, 3077, 2811,
    2566, 2341, 2134, 1946, 1774, 1617, 1475, 1346, 1229, 1124, 1029, 944,
    868, 800, 739, 684, 636, 593, 554, 519, 488, 460, 434, 411, 389,
    369, 350, 331, 313, 296, 278, 261, 244, 226, 209, 191, 174, 156, 139, 122,
    106, 91, 76, 64, 53, 44, 37, 34, 27, 21, 15, 9, 2, 1},
    /* 1168kbps */
{   5912, 5414, 4951, 4520, 4122, 3753, 3413, 3099, 2811, 2546, 2304,
    2083, 1882, 1699, 1534, 1384, 1250, 1129, 1021, 925, 840, 764, 697,
    639, 587, 542, 503, 468, 438, 412, 389, 368, 350, 333, 318, 303, 289,
    276, 262, 249, 235, 221, 206, 191, 175, 159, 143, 127, 110, 94, 78,
    63, 49, 36, 26, 17, 12, 10, 8, 6, 4, 2, 0, 0},
    /* 1552kbps */
{   5682, 5173, 4701, 4265, 3862, 3492, 3151, 2839, 2554, 2294,
    2058, 1844, 1650, 1476, 1320, 1180, 1056, 946, 849, 764, 689, 624,
    568, 520, 478, 443, 413, 388, 366, 348, 332, 318, 306, 295, 284, 274,
    264, 253, 242, 231, 218, 205, 190, 175, 159, 142, 124, 106, 88, 70,
    53, 37, 22, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    /* 2320kbps */
{   5116, 4628, 4177, 3762, 3381, 3031, 2712, 2421, 2156, 1916,
    1699, 1505, 1330, 1175, 1036, 914, 807, 713, 632, 562, 502, 451,
    409, 373, 344, 320, 301, 285, 273, 263, 255, 249, 243, 238, 233, 228,
    222, 215, 207, 198, 188, 177, 164, 149, 134, 118, 100, 83, 65, 47, 29,
    12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}
}; /* end _far_end_signal[][] */

felm_to_db(dummy, felm)
	u_short felm;
{
	int idx, nchan;

	/* Determine FELM Lookup Table Index based on Symbol Rate */
	nchan = BP_global_state.symbol_rate >> 3; /* divide by 8 */
	if (nchan < 3)
		idx = 0;  /* < 192kbps */
	else if (nchan < 5)
		idx = 1;  /* < 320kbps */
	else if (nchan < 7)
		idx = 2;  /* < 448kbps */
	else if (nchan < 10)
		idx = 3;  /* < 640kbps */
	else if (nchan < 15)
		idx = 4;  /* < 960kbps */
	else if (nchan < 21)
		idx = 5;  /* < 1344kbps */
	else if (nchan < 30)
		idx = 6;  /* < 1920kbps */
	else
		idx = 7;  /* >= 1920kbps */
	return(_LookUpTable(felm_to_db_table[idx], felm));
}
