#include "../libc/types.h"
#include "typedefs.h"
#include "config.h"
#include "bitpump.h"
#include "util.h"

/***********************************************************/
/*    _DcCancel()                                          */
/*    Measures average DC level at A/D input, and          */
/*    compensates by subtracting this constant value from  */
/*    all input samples.                                   */
/*                                                         */
/*    returns: void                                        */
/*                                                         */
/*    Input variables: BP_U_8BIT no                        */
/*                                                         */
/*    Output variables: None                               */
/*                                                         */
/*    example:                                             */
/*           _DcCancel(no);                                */
/*                                                         */
/* Programmer:                                             */
/*     Iris Shuker                24-Oct-1993              */
/*                                                         */
/* revision history:                                       */
/*                                                         */
/***********************************************************/

void
_DcCancel()
{
    DECLARE_PTR;

    BP_U_8BIT meter;
    BP_S_16BIT value;

    NORM(meter) /* Calculate meter normalization factor */

    /*----------------------------------------------------*/
    /* Read DC meter value                                */
    /*----------------------------------------------------*/
    READ_METER_REG(dc_meter_low, dc_meter_high, value, meter);


    /*----------------------------------------------------------*/
    /* Set DC offset register to compensate for measured offset */
    /*----------------------------------------------------------*/
    SET_WORD(bp_ptr, dc_offset_low, dc_offset_high , value); /* Set DC offset register */
#ifdef TDEBUG
    PREFIX;
    printf("DC Offset %d\r\n", (int)value);
#endif

} /* END _DcCancel */
