/*
 * The data structure defined in this header file
 * represents the global bitpump state.
 *
 * It is used by some lib8973 routines and also allows
 * the global bitpump interrupt handler to do its job.
 */

struct bpstate {
	u_short	symbol_rate;	/* in 4 kbaud / 8 kbps increments */
	u_char	latched_timer_irq;
	u_char	latched_alarm_irq;
	void	(*sut1_inthandler)();
	u_long	sut1_inthandler_param;
	void	(*sut2_inthandler)();
	u_long	sut2_inthandler_param;
	void	(*sut3_inthandler)();
	u_long	sut3_inthandler_param;
	void	(*sut4_inthandler)();
	u_long	sut4_inthandler_param;
	void	(*meter_tmr_inthandler)();
	u_long	meter_tmr_inthandler_param;
	void	(*snr_tmr_inthandler)();
	u_long	snr_tmr_inthandler_param;
	void	(*t3_inthandler)();
	u_long	t3_inthandler_param;
	void	(*t4_inthandler)();
	u_long	t4_inthandler_param;
	void	(*lowsnr_inthandler)();
	u_long	lowsnr_inthandler_param;
	void	(*lowfelm_inthandler)();
	u_long	lowfelm_inthandler_param;
	void	(*highfelm_inthandler)();
	u_long	highfelm_inthandler_param;
	void	(*sync_inthandler)();
	u_long	sync_inthandler_param;
	u_long	meter_int_count;
};

extern volatile struct bpstate BP_global_state;
