/*
 * Core data structure definitions for the Layer 2 converter
 */

#ifndef __L2CONV_STRUCT_H
#define	__L2CONV_STRUCT_H

struct buffer {
	struct	buffer *buf_next;
	struct	vc *buf_vc;
	u_short	buf_dataoff;
	u_short	buf_datalen;
	u_char	buf_dataspc[4088];
};

#define	AAL5_MAXCELLS	85
#define	AAL5_MAXPAYLOAD	4072
#define	HDLC_RX_LIMIT	4078

struct vc {
	/* configuration */
	u_short	convmode;
	u_short	q922_hdr;
	u_char	cellhdr_normal[6];	/* 5 bytes + padding */
	u_char	cellhdr_last[6];	/* ditto */
	/* AAL5 Rx in progress */
	int	aal5_rx_state;
	struct	buffer *aal5_rx_buf;
	u_char	*aal5_rx_ptr;
	int	aal5_rx_count;
	u_long	aal5_rx_crcaccum;
	/* stats */
	u_long	atm_rx_packets;
	u_long	atm_rx_giants;
	u_long	atm_rx_badcrc32;
	u_long	atm_rx_aborts;
	u_long	atm_rx_badlen;
	u_long	rx_encap_ipv4;
	u_long	rx_encap_ipv6;
	u_long	rx_encap_routed;
	u_long	rx_encap_bridged;
	u_long	rx_encap_otheroui;
	u_long	rx_encap_ppp;
	u_long	rx_encap_nlpid;
	u_long	rx_encap_invalid;
	u_long	tx_packets_converted;
};

/* VC conversion modes */
#define	CONVMODE_FRF5		0x01
#define	CONVMODE_FRF8		0x02
#define	CONVMODE_FUNI		0x03
#define	CONVMODE_PPPOA_LLC	0x04
#define	CONVMODE_PPPOA_VC	0x05
#define	CONVMODE_IPV4_VC	0x06

/* AAL5 Rx state machine */
#define	AAL5RX_STATE_IDLE	0
#define	AAL5RX_STATE_INPROGRESS	1
#define	AAL5RX_STATE_DISCARD	2

#endif
