/*
 * Generic buffer management code
 */

#include "types.h"
#include "bufmac.h"
#include "param.h"

struct buffer *buf_freelist;

init_buf_freelist()
{
	struct buffer *buf;
	int i;

	buf = (struct buffer *)BUFBASE;
	buf_freelist = buf;
	for (i = 0; i < NBUFS-1; buf++, i++)
		buf->buf_next = buf + 1;
	buf->buf_next = 0;
	return(0);
}

struct buffer *
get_buffer()
{
	struct buffer *buf;
	u_short save_sr;

	asm volatile ("move.w %%sr,%0" : "=dm" (save_sr) : );
	asm volatile ("move.w #0x2700,%%sr" : : : "cc");
	buf = buf_freelist;
	if (!buf) {
		printf("L2CONV BUG: out of buffers\r\n");
		asm("trap #0");
	}
	buf_freelist = buf->buf_next;
	asm volatile ("move.w %0,%%sr" : : "dm" (save_sr) : "cc");
	return(buf);
}

free_buffer(buf)
	struct buffer *buf;
{
	u_short save_sr;

	asm volatile ("move.w %%sr,%0" : "=dm" (save_sr) : );
	asm volatile ("move.w #0x2700,%%sr" : : : "cc");
	buf->buf_next = buf_freelist;
	buf_freelist = buf;
	asm volatile ("move.w %0,%%sr" : : "dm" (save_sr) : "cc");
}
