#include "../libc/types.h"
#include "api.h"

extern int		l2conv_init();
extern void		get_global_config();
extern struct buffer *	get_buffer();
extern void		free_buffer();
extern int		pkt_atm2hdlc();
extern int		pkt_hdlc2atm();
extern void		show_vc_conf();
extern void		show_vc_stats();
extern void		zero_vc_stats();

const struct l2conv_api l2conv_api_table
	__attribute__ ((section (".rodata")))
	= {
	/* ID fields */
	L2CONV_MAGIC,
	L2CONV_APIVER,
	sizeof(struct l2conv_api),
	/* function pointers */
	l2conv_init,
	get_global_config,
	get_buffer,
	free_buffer,
	pkt_atm2hdlc,
	pkt_hdlc2atm,
	show_vc_conf,
	show_vc_stats,
	zero_vc_stats
};
