/*
 * This is a test feature that allows a hacker to send a Nokia EOC message
 * via a craft command.
 */

#include "types.h"
#include "ctype.h"
#include "stdio.h"
#include "strings.h"
#include "sdsl_asm.h"
#include "globals.h"

u_char crafteoc_raw_buf[32] = {0xFF, 0x03, 0xAA, 0xAA, 0x03, 0x00, 0x60, 0xF9,
				0x00, 0x01};

u_char crafteoc_output_buf[64];

#define	CRAFTEOC_PREFILLED	10
#define	CRAFTEOC_MAX		30

craft_eoc(cmd)
	char *cmd;
{
	int pos, byte, c;

	if (sdsl_asm_state != ACTIVE_STATE) {
		printf("EOC command not valid except in ACTIVE_STATE\r\n");
		return;
	}
	if (tx_eoc_msg_count) {
	printf("Please wait: a previous EOC message is still transmitting\r\n");
		return;
	}
	for (pos = CRAFTEOC_PREFILLED; ; pos++) {
		while (isspace(*cmd))
			cmd++;
		if (!*cmd)
			break;
		if (!isxdigit(*cmd)) {
			printf("EOC command: invalid syntax\r\n");
			return;
		}
		if (pos >= CRAFTEOC_MAX) {
			printf("EOC command: too many bytes given\r\n");
			return;
		}
		for (byte = 0; isxdigit(c = *cmd); cmd++) {
			byte <<= 4;
			if (isdigit(c))
				byte += c - '0';
			else if (isupper(c))
				byte += c - 'A' + 10;
			else
				byte += c - 'a' + 10;
		}
		crafteoc_raw_buf[pos] = byte;
	}
	rfc1662_append_fcs16(crafteoc_raw_buf, pos);
	craft_eoc_pushout(pos + 2);
}

craft_eoc_pushout(len)
	int len;
{
	u_char *cp, *dp;
	int c, outlen;

	cp = crafteoc_raw_buf;
	dp = crafteoc_output_buf;
	for (outlen = 0; len; len--) {
		c = *cp++;
		if (c == 0x7D) {
			*dp++ = 0x7D;
			*dp++ = 0x5D;
			outlen += 2;
		} else if (c == 0x7E) {
			*dp++ = 0x7D;
			*dp++ = 0x5E;
			outlen += 2;
		} else {
			*dp++ = c;
			outlen++;
		}
	}
	*dp++ = 0x7E;
	*dp++ = 0x7E;
	outlen += 2;
	tx_eoc_msg_ptr = crafteoc_output_buf;
	tx_eoc_msg_count = outlen;
}
