/*
 * L2CNF1-specific craft terminal commands
 */

#include "types.h"
#include "ctype.h"
#include "stdio.h"
#include "strings.h"
#include "sdsl_asm.h"
#include "../lib8973/bpstate.h"
#include "globals.h"

extern volatile long timebase;

extern char *sdsl_asm_states[];

extern int cmd_stats();
extern int craft_eoc();

cmd_retrain()
{
	switch (sdsl_asm_state) {
	case ACTIVATING_STATE:
	case FRAME_ACQU_STATE:
	case ACTIVE_STATE:
		set_sdsl_state(DEACTIVATED_STATE);
		break;
	default:
		printf("RETRAIN command ignored in %s\r\n",
			sdsl_asm_states[sdsl_asm_state]);
	}
}

cmd_speed(arg)
	char *arg;
{
	char *cp, *np;
	int val;

	if (sdcore_state.terminal_type && sdcore_state.preact_type) {
	    printf("SPEED command not supported on Nokia AutoBaud STU-R\r\n");
		return;
	}
	for (cp = arg; isspace(*cp); cp++)
		;
	if (!*cp) {
inv:		printf("Syntax error: numeric argument required\r\n");
		return;
	}
	for (np = cp; *cp && !isspace(*cp); cp++)
		;
	if (*cp)
		*cp++ = '\0';
	if (!opcore_api->is_string_num(np))
		goto inv;
	val = atoi(np);
	if (!sdcore_api->datarate_issup(val)) {
		printf("Requested speed is not a valid SDSL data rate\r\n");
		return;
	}
	/* do it! */
	sdcore_state.user_data_rate = val >> 3;
	if (sdsl_asm_state == ACTIVATING_STATE ||
	    sdsl_asm_state == FRAME_ACQU_STATE ||
	    sdsl_asm_state == ACTIVE_STATE)
		set_sdsl_state(DEACTIVATED_STATE);
}

static
paren_bit_output(flg, text, latch)
	int flg, *latch;
	char *text;
{
	if (!flg)
		return;
	printf("%s%s", *latch ? ", " : " (", text);
	*latch = 1;
}

cmd_show_status()
{
	u_char stat;
	int latch = 0;

	opcore_api->print_timeint("DSU uptime", timebase);
	if (sdcore_state.terminal_type && sdcore_state.preact_type)
		printf("Automatic data rate detection via Nokia AutoBaud\r\n");
	else
		printf("Configured data rate: %u kbps\r\n",
			sdcore_state.user_data_rate << 3);
	printf("SDSL ASM state: %s (link %s)\r\n",
		sdsl_asm_states[sdsl_asm_state],
		sdsl_asm_state == ACTIVE_STATE ? "up" : "down");
	if (sdsl_asm_state == ACTIVE_STATE) {
		opcore_api->print_timeint("Link uptime",
					  timebase - sdsl_asm_state_time);
		if (sdcore_state.terminal_type && sdcore_state.preact_type)
			printf("Active data rate: %u kbps\r\n",
				sdcore_state.user_data_rate << 3);
	}
	stat = sdcore_state.status.byte;
	printf("SDCORE status: %02X", stat);
	paren_bit_output(stat & 0x80, "Normal op", &latch);
	paren_bit_output(stat & 0x40, "Tx 4-level", &latch);
	paren_bit_output(stat & 0x20, "LOST running", &latch);
	paren_bit_output(stat & 0x10, "Preact done", &latch);
	paren_bit_output(stat & 0x08, "Timer expired", &latch);
	paren_bit_output(stat & 0x04, "T/R rev", &latch);
	paren_bit_output(stat & 0x02, "LOST", &latch);
	paren_bit_output(stat & 0x01, "LOS", &latch);
	printf("%s\r\n", latch ? ")" : "");
	return(0);
}

register_custom_craft_commands()
{
	opcore_api->register_craft_command("STATS", 5, cmd_stats);
	opcore_api->register_craft_command("RETRAIN", 7, cmd_retrain);
	opcore_api->register_craft_command("SPEED", 5, cmd_speed);
	opcore_api->register_craft_command("EOC", 3, craft_eoc);
	opcore_api->register_show_subcmd("STATUS", 4, cmd_show_status);
	opcore_api->register_show_subcmd("VCCONF", 2, l2conv_api->show_vc_conf);
	opcore_api->register_show_subcmd("VCLIST", 2, l2conv_api->show_vc_conf);
	return(0);
}
