#include "types.h"
#include "ctype.h"
#include "strings.h"
#include "stdio.h"
#include "monitor_api.h"
#include "globals.h"

get_config()
{
	int i;

	i = opcore_api->get_ttype();
	if (i < 0)
		return(i);
	i = get_preact_type();
	if (i < 0)
		return(i);
	if (!sdcore_state.terminal_type || !sdcore_state.preact_type) {
		i = opcore_api->get_datarate();
		if (i < 0)
			return(i);
	}
	i = get_frame_acqu_time();
	if (i < 0)
		return(i);
	i = get_lost_timeout();
	if (i < 0)
		return(i);
	i = get_losw_count();
	if (i < 0)
		return(i);
	i = get_nokia_idle();
	if (i < 0)
		return(i);
	i = get_eoc_octet();
	if (i < 0)
		return(i);
	i = get_atm_outq_size();
	if (i < 0)
		return(i);
	i = get_hdlc_inq_size();
	if (i < 0)
		return(i);
	i = get_hdlc_outq_size();
	if (i < 0)
		return(i);
	return(0);
}

get_preact_type()
{
	char *s;

	s = opcore_api->config_search("preact_type");
	if (!s || !strcasecmp(s, "none") || !strcasecmp(s, "fixed") ||
	    !strcasecmp(s, "N1")) {
		sdcore_state.preact_type = PREACT_TYPE_NONE;
		return(0);
	} else if (!strcasecmp(s, "AutoBaud") || !strcasecmp(s, "N3")) {
		sdcore_state.preact_type = PREACT_TYPE_AUTOBAUD;
		if (!sdcore_state.terminal_type) {
			/* the flavor ID bytes as set by the real DSLAM */
			sdcore_state.cnxab_htuc_flavor[0] = 0x09;
			sdcore_state.cnxab_htuc_flavor[1] = 0x04;
			return(opcore_api->get_preact_fallback());
		}
		return(0);
	} else if (!strcasecmp(s, "CM") || !strcasecmp(s, "IFCTF")) {
		monapi_error("preact_type=%s: invalid for Nokia SDSL", s);
		return(-1);
	} else {
		monapi_error("preact_type=%s: invalid setting", s);
		return(-1);
	}
}

get_frame_acqu_time()
{
	char *s;
	int val;

	s = opcore_api->config_search("frame_acqu_time");
	if (!s) {
		val = 10;	/* 10 s default */
		goto set;
	}
	if (!opcore_api->is_string_num(s)) {
inv:		monapi_error("frame_acqu_time=%s: invalid setting", s);
		return(-1);
	}
	val = atoi(s);
	if (!val)
		goto inv;
set:	frame_acqu_time = val * 20;
	return(0);
}

get_lost_timeout()
{
	char *s;
	int val;

	s = opcore_api->config_search("los_lost_timeout");
	if (!s) {
		val = 30;	/* 30 s default */
		goto set;
	}
	if (!opcore_api->is_string_num(s)) {
		monapi_error("los_lost_timeout=%s: invalid setting", s);
		return(-1);
	}
	val = atoi(s);
set:	los_lost_timeout = val * 20;
	return(0);
}

get_losw_count()
{
	char *s;
	int val;

	s = opcore_api->config_search("nokia_losw_count");
	if (!s) {
		val = 7;	/* default from Hack-o-Rocket */
		goto set;
	}
	if (!opcore_api->is_string_num(s)) {
inv:		monapi_error("nokia_losw_count=%s: invalid setting", s);
		return(-1);
	}
	val = atoi(s);
	if (!val)
		goto inv;
set:	nokia_losw_count = val;
	return(0);
}

get_nokia_idle()
{
	char *s;
	int val;

	s = opcore_api->config_search("initial_idle_frames");
	if (!s) {
		val = 50;	/* default from Hack-o-Rocket */
		goto set;
	}
	if (!opcore_api->is_string_num(s)) {
		monapi_error("initial_idle_frames=%s: invalid setting", s);
		return(-1);
	}
	val = atoi(s);
set:	nokia_initial_idle = val;
	return(0);
}

get_eoc_octet()
{
	char *s;
	int i;
	u_long accum;

	s = opcore_api->config_search("eoc_octet");
	if (!s) {
		/* what Netopia and EN do for Flavor N1 */
		tx_eoc_octet = 0xFF;
		return(0);
	}
	if (!isxdigit(s[0]) || !isxdigit(s[1]) || s[2]) {
		monapi_error("eoc_octet=%s: invalid setting", s);
		return(-1);
	}
	for (i = 0, accum = 0; i < 2; i++, s++) {
		accum <<= 4;
		if (isdigit(*s))
			accum += *s - '0';
		else if (isupper(*s))
			accum += *s - 'A' + 10;
		else
			accum += *s - 'a' + 10;
	}
	tx_eoc_octet = accum;
	return(0);
}

get_atm_outq_size()
{
	char *s;
	int val;

	s = opcore_api->config_search("atm_outq_size");
	if (!s) {
		val = 8;	/* default from previous implementations */
		goto set;
	}
	if (!opcore_api->is_string_num(s)) {
inv:		monapi_error("atm_outq_size=%s: invalid setting", s);
		return(-1);
	}
	val = atoi(s);
	if (val < 1 || val > 8)
		goto inv;
set:	atm_outq_limit = val;
	return(0);
}

get_hdlc_inq_size()
{
	char *s;
	int val;

	s = opcore_api->config_search("hdlc_inq_size");
	if (!s) {
		val = 8;	/* default to hw max for now */
		goto set;
	}
	if (!opcore_api->is_string_num(s)) {
inv:		monapi_error("hdlc_inq_size=%s: invalid setting", s);
		return(-1);
	}
	val = atoi(s);
	if (val < 1 || val > 8)
		goto inv;
set:	scc2_rxring_size = val;
	return(0);
}

get_hdlc_outq_size()
{
	char *s;
	int val;

	s = opcore_api->config_search("hdlc_outq_size");
	if (!s) {
		val = 8;	/* default to hw max for now */
		goto set;
	}
	if (!opcore_api->is_string_num(s)) {
inv:		monapi_error("hdlc_outq_size=%s: invalid setting", s);
		return(-1);
	}
	val = atoi(s);
	if (val < 1 || val > 8)
		goto inv;
set:	hdlc_txq_limit = val;
	return(0);
}
