/*
 * Packet queue management
 */

#include "types.h"
#include "globals.h"

put_buffer_on_queue(buf, q)
	struct buffer *buf;
	struct pktqueue *q;
{
	u_short save_sr;

	buf->buf_next = NULL;
	asm volatile ("move.w %%sr,%0" : "=dm" (save_sr) : );
	asm volatile ("move.w #0x2700,%%sr" : : : "cc");
	if (q->q_count) {
		q->q_tail->buf_next = buf;
		q->q_tail = buf;
		q->q_count++;
	} else {
		q->q_head = buf;
		q->q_tail = buf;
		q->q_count = 1;
	}
	asm volatile ("move.w %0,%%sr" : : "dm" (save_sr) : "cc");
}

struct buffer *
get_buffer_from_queue(q)
	struct pktqueue *q;
{
	u_short save_sr;
	struct buffer *buf;

	asm volatile ("move.w %%sr,%0" : "=dm" (save_sr) : );
	asm volatile ("move.w #0x2700,%%sr" : : : "cc");
	buf = q->q_head;
	if (!buf)
		goto out;
	q->q_head = buf->buf_next;
	q->q_count--;
	if (!q->q_count)
		q->q_tail = NULL;
out:	asm volatile ("move.w %0,%%sr" : : "dm" (save_sr) : "cc");
	return(buf);
}

queue_head_drop(q, limit)
	struct pktqueue *q;
	int limit;
{
	u_short save_sr;
	struct buffer *buf;

	asm volatile ("move.w %%sr,%0" : "=dm" (save_sr) : );
	asm volatile ("move.w #0x2700,%%sr" : : : "cc");
	if (q->q_count <= limit) {
		asm volatile ("move.w %0,%%sr" : : "dm" (save_sr) : "cc");
		return(0);
	}
	buf = q->q_head;
	q->q_head = buf->buf_next;
	q->q_count--;
	asm volatile ("move.w %0,%%sr" : : "dm" (save_sr) : "cc");
	l2conv_api->free_buffer(buf);
	return(1);
}
