#include "types.h"
#include "stdio.h"
#include "mc68302.h"
#include "intr.h"
#include "gpio.h"
#include "monitor_api.h"
#include "sdsl_asm.h"
#include "globals.h"

extern caddr_t m68000_vectors[];
extern volatile struct mc68302_regs mc68302_regs;
extern volatile long timebase;

extern char _Xvec_scc2;
extern char _Xvec_fpga_rx;
extern char _Xvec_fpga_tx;

extern struct sdcore_api *fetch_sdcore();
extern struct opcore_api *fetch_opcore();
extern struct l2conv_api *fetch_l2conv();
extern caddr_t malloc();
extern void fpga_tx_reset_pulse();

static const u_short appname[2] = {0x5003, 0x2761};

init()
{
	printf("\r\nATM/HDLC converting DSU (Flavor A) code running\r\n");
	printf("Warning: this operation mode is EXPERIMENTAL and UNSUPPORTED!\r\n");
	if (sdcore_init() < 0)
		return(-1);
	opcore_api = fetch_opcore();
	if (!opcore_api) {
		/* error message already printed */
		return(-1);
	}
	if (opcore_api->init(appname, sdcore_api, &sdcore_state) < 0)
		return(-1);
	l2conv_api = fetch_l2conv();
	if (!l2conv_api) {
		/* error message already printed */
		return(-1);
	}
	if (l2conv_api->init() < 0)
		return(-1);
	if (get_config() < 0)
		return(-1);
	if (fpga_regs_init() < 0)
		return(-1);
	l2conv_api->get_global_cfg(&l2conv_global);
	bzero(&atm_outgoing_queue, sizeof atm_outgoing_queue);
	if (opcore_api->setup_scc2() < 0)
		return(-1);
	m68000_vectors[INTVEC_PB11] = &_Xvec_fpga_rx;
	m68000_vectors[INTVEC_SCC2] = &_Xvec_scc2;
	m68000_vectors[INTVEC_IRQ6] = &_Xvec_fpga_tx;
	bzero(&stats, sizeof stats);
	hdlc_init();
	mc68302_regs.padat = (mc68302_regs.padat & ~PORTA_TXMUX_MASK) |
				PORTA_TXMUX_FPGA;
	register_custom_craft_commands();
	sdsl_asm_state = INACTIVE_STATE;
	sdcore_state.fpga_bclk_reset = fpga_tx_reset_pulse;
	sdcore_state.tempenv_critsect_irqmask = INTMASK_PB11 | INTMASK_SCC2;
	timebase = 0;
	return(0);
}

sdcore_init()
{
	caddr_t privstate;

	sdcore_api = fetch_sdcore();
	if (!sdcore_api) {
		/* error message already printed */
		return(-1);
	}
	privstate = malloc(sdcore_api->sizeof_privstate);
	sdcore_api->swinit(&sdcore_state, privstate);
	return(0);
}
