/*
 * Rx side of the FPGA is handled here
 */

#include "types.h"
#include "globals.h"
#include "i4321_fpga.h"
#include "mc68302.h"
#include "intr.h"
#include "gpio.h"
#include "sdsl_asm.h"

extern volatile struct mc68302_regs mc68302_regs;
extern volatile struct i4321_memblock FPGA_regs;

extern volatile long timebase;

fpga_rx_inthandler()
{
	while (FPGA_regs.rxcsr & I4321_RXCSR_HAVE_DATA) {
		if (celldelim_sync) {
			atm_cell_rx(&FPGA_regs.rx_cell);
			if (FPGA_regs.rx_cell.hec_syndrome) {
				stats.atm_rx_badhec++;
				celldelim_counter++;
			} else
				celldelim_counter = 0;
			if (celldelim_counter >= i4321_alpha) {
				i4321_rehunt();
				stats.sdsl_locd_events++;
				return;
			}
		} else {
			if (FPGA_regs.rx_cell.hec_syndrome) {
				i4321_rehunt();
				return;
			} else
				celldelim_counter++;
			if (celldelim_counter >= i4321_delta + 1) {
				celldelim_sync = 1;
				celldelim_counter = 0;
			}
		}
		mc68302_regs.ipr = INTMASK_PB11;
		FPGA_regs.rx_ack = 1;
	}
}

i4321_rehunt()
{
	FPGA_regs.rxcsr = I4321_RXCSR_RESET;
	cpu_delay_us(100);
	FPGA_regs.rxcsr = 0;
	celldelim_sync = 0;
	celldelim_counter = 0;
}

sdsl_startup_success()
{
	fpga_tx_enable();
	celldelim_sync = 0;
	celldelim_counter = 0;
	stats.atm_rx_badhec = 0;	/* make it per startup cycle */
	mc68302_regs.imr |= INTMASK_PB11;
	FPGA_regs.rxcsr = 0;
	printf("Bitpump activation successful, hunting for ATM cells\r\n");
	printf("Startup time %d s\r\n", (timebase - sdsl_asm_state_time) / 20);
	set_sdsl_state(FRAME_ACQU_STATE);
	mc68302_regs.padat = mc68302_regs.padat & ~PORTA_LSLED_MASK
				| PORTA_LSLED_ORANGE;
}

sdsl_rx_shutdown()
{
	mc68302_regs.imr &= ~INTMASK_PB11;
	FPGA_regs.rxcsr = I4321_RXCSR_RESET;
}
