#include "types.h"
#include "ctype.h"
#include "strings.h"
#include "stdio.h"
#include "monitor_api.h"
#include "globals.h"

get_config()
{
	int i;

	i = opcore_api->get_ttype();
	if (i < 0)
		return(i);
	i = get_sss_setting();
	if (i < 0)
		return(i);
	i = get_coset_setting();
	if (i < 0)
		return(i);
	i = get_preact_type();
	if (i < 0)
		return(i);
	if (!sdcore_state.terminal_type || !sdcore_state.preact_type) {
		i = opcore_api->get_datarate();
		if (i < 0)
			return(i);
	}
	i = opcore_api->get_quat_orient();
	if (i < 0)
		return(i);
	i = get_frame_acqu_time();
	if (i < 0)
		return(i);
	i = get_lost_timeout();
	if (i < 0)
		return(i);
	i = get_pend_gracetime();
	if (i < 0)
		return(i);
	i = get_initial_idle();
	if (i < 0)
		return(i);
	i = get_atm_outq_size();
	if (i < 0)
		return(i);
	i = get_hdlc_inq_size();
	if (i < 0)
		return(i);
	i = get_hdlc_outq_size();
	if (i < 0)
		return(i);
	i = get_i4321_alpha();
	if (i < 0)
		return(i);
	i = get_i4321_delta();
	if (i < 0)
		return(i);
	return(0);
}

get_preact_type()
{
	char *s;

	s = opcore_api->config_search("preact_type");
	if (!s || !strcasecmp(s, "none")) {
		sdcore_state.preact_type = PREACT_TYPE_NONE;
		return(0);
	} else if (!strcasecmp(s, "AutoBaud")) {
		sdcore_state.preact_type = PREACT_TYPE_AUTOBAUD;
		if (!sdcore_state.terminal_type) {
			sdcore_state.cnxab_htuc_flavor[0] = 0x01;
			sdcore_state.cnxab_htuc_flavor[1] = 0;
			if (flavor_setting_sss)
				sdcore_state.cnxab_htuc_flavor[1] |= 0x01;
			if (flavor_setting_coset)
				sdcore_state.cnxab_htuc_flavor[1] |= 0x04;
			return(opcore_api->get_preact_fallback());
		}
		return(0);
	} else if (!strcasecmp(s, "CM") || !strcasecmp(s, "IFCTF")) {
		monapi_error("preact_type=%s: invalid for SDSL/ATM", s);
		return(-1);
	} else {
		monapi_error("preact_type=%s: invalid setting", s);
		return(-1);
	}
}

get_frame_acqu_time()
{
	char *s;
	int val;

	s = opcore_api->config_search("frame_acqu_time");
	if (!s) {
		val = 10;	/* 10 s default */
		goto set;
	}
	if (!opcore_api->is_string_num(s)) {
inv:		monapi_error("frame_acqu_time=%s: invalid setting", s);
		return(-1);
	}
	val = atoi(s);
	if (!val)
		goto inv;
set:	frame_acqu_time = val * 20;
	return(0);
}

get_lost_timeout()
{
	char *s;
	int val;

	s = opcore_api->config_search("los_lost_timeout");
	if (!s) {
		val = 30;	/* 30 s default */
		goto set;
	}
	if (!opcore_api->is_string_num(s)) {
		monapi_error("los_lost_timeout=%s: invalid setting", s);
		return(-1);
	}
	val = atoi(s);
set:	los_lost_timeout = val * 20;
	return(0);
}

get_initial_idle()
{
	char *s;
	int val;

	s = opcore_api->config_search("initial_idle_cells");
	if (!s) {
		val = 100;	/* rather arbitrary default */
		goto set;
	}
	if (!opcore_api->is_string_num(s)) {
		monapi_error("initial_idle_cells=%s: invalid setting", s);
		return(-1);
	}
	val = atoi(s);
set:	initial_idle_cells = val;
	return(0);
}

get_atm_outq_size()
{
	char *s;
	int val;

	s = opcore_api->config_search("atm_outq_size");
	if (!s) {
		val = 8;	/* default from previous implementations */
		goto set;
	}
	if (!opcore_api->is_string_num(s)) {
inv:		monapi_error("atm_outq_size=%s: invalid setting", s);
		return(-1);
	}
	val = atoi(s);
	if (val < 1 || val > 8)
		goto inv;
set:	atm_outq_limit = val;
	return(0);
}

get_hdlc_inq_size()
{
	char *s;
	int val;

	s = opcore_api->config_search("hdlc_inq_size");
	if (!s) {
		val = 8;	/* default to hw max for now */
		goto set;
	}
	if (!opcore_api->is_string_num(s)) {
inv:		monapi_error("hdlc_inq_size=%s: invalid setting", s);
		return(-1);
	}
	val = atoi(s);
	if (val < 1 || val > 8)
		goto inv;
set:	scc2_rxring_size = val;
	return(0);
}

get_hdlc_outq_size()
{
	char *s;
	int val;

	s = opcore_api->config_search("hdlc_outq_size");
	if (!s) {
		val = 8;	/* default to hw max for now */
		goto set;
	}
	if (!opcore_api->is_string_num(s)) {
inv:		monapi_error("hdlc_outq_size=%s: invalid setting", s);
		return(-1);
	}
	val = atoi(s);
	if (val < 1 || val > 8)
		goto inv;
set:	hdlc_txq_limit = val;
	return(0);
}

get_pend_gracetime()
{
	char *s;
	int val;

	s = opcore_api->config_search("pending_deact_gracetime");
	if (!s) {
		val = 40;	/* 2 s default */
		goto set;
	}
	if (!opcore_api->is_string_num(s)) {
		monapi_error("pending_deact_gracetime=%s: invalid setting", s);
		return(-1);
	}
	val = atoi(s);
set:	pending_deact_gracetime = val;
	return(0);
}

get_sss_setting()
{
	char *s;
	int bool;

	s = opcore_api->config_search("flavora_sss");
	if (!s) {
		flavor_setting_sss = 1;
		return(0);
	}
	bool = opcore_api->parse_boolean_param(s);
	if (bool < 0) {
		monapi_error("flavora_sss=%s: invalid setting", s);
		return(-1);
	}
	flavor_setting_sss = bool;
	return(0);
}

get_coset_setting()
{
	char *s;
	int bool;

	s = opcore_api->config_search("flavora_coset");
	if (!s) {
		flavor_setting_coset = 1;
		return(0);
	}
	bool = opcore_api->parse_boolean_param(s);
	if (bool < 0) {
		monapi_error("flavora_coset%s: invalid setting", s);
		return(-1);
	}
	flavor_setting_coset = bool;
	return(0);
}

get_i4321_alpha()
{
	char *s;
	int val;

	s = opcore_api->config_search("i4321_alpha");
	if (!s) {
		val = 7;	/* from the spec */
		goto set;
	}
	if (!opcore_api->is_string_num(s)) {
inv:		monapi_error("i4321_alpha=%s: invalid setting", s);
		return(-1);
	}
	val = atoi(s);
	if (!val)
		goto inv;
set:	i4321_alpha = val;
	return(0);
}

get_i4321_delta()
{
	char *s;
	int val;

	s = opcore_api->config_search("i4321_delta");
	if (!s) {
		val = 7;	/* compromise between "SDH" and "cell" values */
		goto set;
	}
	if (!opcore_api->is_string_num(s)) {
		monapi_error("i4321_delta=%s: invalid setting", s);
		return(-1);
	}
	val = atoi(s);
set:	i4321_delta = val;
	return(0);
}
