#ifndef __SDSL_ASM_H
#define	__SDSL_ASM_H

/*
 * Our SDSL Activation State Machine is based on the HDSL one
 * and on Brooktree's example implementation, adapted for flavors
 * of interest to us.
 *
 * Additional changes between Hack-o-Rocket and OSDCU:
 * - WAIT_FOR_DTR added (HDSL equivalent was inside INACTIVE_STATE)
 * - ACTIVE_TX_RX_STATE shortened to just ACTIVE_STATE
 * - Pending Deactivated State dropped; it is now a substate of Active
 */

#define INACTIVE_STATE		0
#define	WAIT_FOR_DTR		1
#define ACTIVATING_STATE	2
#define FRAME_ACQU_STATE	3
#define ACTIVE_STATE		4
#define DEACTIVATED_STATE	5
#define WAIT_FOR_LOST		6
#define WAIT_FOR_LOS		7

#endif	/* __SDSL_ASM_H */
