/*
 * This header file defines the registers and data structures
 * placed in the M68K address space by the NOKFTX (Nokia frame transmitter)
 * FPGA.
 */

#ifndef __NOKFTX_H
#define	__NOKFTX_H

struct nokftx_atmcell {
	u_char	cellhdr[4];
	u_char	hec_coset;
	u_char	pad;
	u_char	payload[48];
};

struct nokftx_frame {
	struct	nokftx_atmcell cells[8];
	u_char	trailer[6];
	u_char	crc6;
	u_char	sync_octet;
	u_char	pad[72];
};

struct nokftx_memblock {
	u_short	id_reg;
	u_short	csr;
	u_char	mirror1[4092];
	struct	nokftx_frame buffers[2];
	u_char	mirror2[3072];
};

#define	NOKFTX_IDREG	0x4E01

/* CSR bit definitions */
#define	NOKFTX_CSR_RESET	0x8000
#define	NOKFTX_CSR_QCLKINV	0x4000
#define	NOKFTX_CSR_CRC32_EN	0x0200
#define	NOKFTX_CSR_IDLE_EN	0x0100
#define	NOKFTX_CSR_INT_EN	0x0080
#define	NOKFTX_CSR_BUF_LAST_WR	0x0010
#define	NOKFTX_CSR_BUF_CUR_TX	0x0008

#endif	/* __NOKFTX_H */
