/*
 * This header file contains struct definitions for MC68302 registers
 * and parameter RAM data structures.
 */

struct mc68302_regs {
	u_short	res1;
	/* IDMA */
	u_short	cmr;
	u_char	*sapr;
	u_char	*dapr;
	u_short	bcr;
	u_char	csr;
	u_char	res2;
	u_char	fcr;
	u_char	res3;
	/* interrupt controller */
	u_short	gimr;
	u_short	ipr;
	u_short	imr;
	u_short	isr;
	u_short	res4[2];
	/* PIO */
	u_short	pacnt;
	u_short	paddr;
	u_short	padat;
	u_short	pbcnt;
	u_short	pbddr;
	u_short	pbdat;
	u_short	res6[3];
	/* chip selects */
	u_short	br0;
	u_short	or0;
	u_short	br1;
	u_short	or1;
	u_short	br2;
	u_short	or2;
	u_short	br3;
	u_short	or3;
	/* timers */
	struct	mc68302_timer_regs {
		u_short	tmr;
		u_short	trr;
		u_short	tcr;
		u_short	tcn;
		u_char	res1;
		u_char	ter;
		u_short	wrr;
		u_short	wcn;
		u_short	res2;
	} timer1, timer2;
	/* CP */
	u_char	cr;
	u_char	res7[31];
	/* SCCs */
	struct	mc68302_scc_regs {
		u_short	res1;
		u_short	scon;
		u_short	scm;
		u_short	dsr;
		u_char	scce;
		u_char	res2;
		u_char	sccm;
		u_char	res3;
		u_char	sccs;
		u_char	res4[3];
	} scc1, scc2, scc3;
	u_char	spmode_scp;
	u_char	spmode_smc;
	u_short	simask;
	u_short	simode;
};

struct mc68302_scc_bd {
	u_short	bd_flags;
	u_short	bd_len;
	u_char	*bd_bufptr;
};

struct mc68302_scc_params {
	u_char	rfcr;
	u_char	tfcr;
	u_short	mrblr;
	u_short	rx_int_state;
	u_char	res1;
	u_char	rbdn;
	u_long	rx_int_dptr;
	u_short	rx_int_bcnt;
	u_short	rx_temp;
	u_short	tx_int_state;
	u_char	res2;
	u_char	tbdn;
	u_long	tx_int_dptr;
	u_short	tx_int_bcnt;
	u_short	tx_temp;
	u_short	protdep[18];
};

struct mc68302_scc_hdlcparams {
	/* common */
	u_char	rfcr;
	u_char	tfcr;
	u_short	mrblr;
	u_short	rx_int_state;
	u_char	res1;
	u_char	rbdn;
	u_long	rx_int_dptr;
	u_short	rx_int_bcnt;
	u_short	rx_temp;
	u_short	tx_int_state;
	u_char	res2;
	u_char	tbdn;
	u_long	tx_int_dptr;
	u_short	tx_int_bcnt;
	u_short	tx_temp;
	/* protocol-specific for HDLC */
	u_short	rcrc_l;
	u_short	rcrc_h;
	u_short	c_mask_l;
	u_short	c_mask_h;
	u_short	tcrc_l;
	u_short	tcrc_h;
	u_short	disfc;
	u_short	crcec;
	u_short	abtsc;
	u_short	nmarc;
	u_short	retrc;
	u_short	mflr;
	u_short	max_cnt;
	u_short	hmask;
	u_short	haddr[4];
};

struct mc68302_scc_uartparams {
	/* common */
	u_char	rfcr;
	u_char	tfcr;
	u_short	mrblr;
	u_short	rx_int_state;
	u_char	res1;
	u_char	rbdn;
	u_long	rx_int_dptr;
	u_short	rx_int_bcnt;
	u_short	rx_temp;
	u_short	tx_int_state;
	u_char	res2;
	u_char	tbdn;
	u_long	tx_int_dptr;
	u_short	tx_int_bcnt;
	u_short	tx_temp;
	/* protocol-specific for UART */
	u_short	max_idl;
	u_short	idlc;
	u_short	brkcr;
	u_short	parec;
	u_short	frmec;
	u_short	nosec;
	u_short	brkec;
	u_short	uaddr1;
	u_short	uaddr2;
	u_short	rccr;
	u_short	ctlchar[8];
};
