/*
 * This header file defines the registers and data structures
 * placed in the M68K address space by the I.432.1 FPGA.
 */

#ifndef __I4321_FPGA_H
#define	__I4321_FPGA_H

struct atmcell64 {
	u_char	cellhdr[4];
	u_char	hec_syndrome;
	u_char	pad[11];
	u_char	payload[48];
};

struct i4321_memblock {
	u_short	id_reg;
	u_char	sss_ctrl;
	u_char	hec_coset;
	u_short	rxcsr;
	u_short	txcsr;
	u_char	gap1[504];
	struct	atmcell64 rx_cell;
	u_short	rx_ack;
	u_short	rx_overrun_count;
	u_short	rx_debug;
	u_char	gap2[442];
	struct	atmcell64 tx_cells[8];
	u_char	pad[512];
};

#define	I4321_IDREG	0x4901

/* Rx CSR bit definitions */
#define	I4321_RXCSR_RESET	0x8000
#define	I4321_RXCSR_SYNC	0x0002
#define	I4321_RXCSR_HAVE_DATA	0x0001

/* Tx CSR bit definitions */
#define	I4321_TXCSR_RESET	0x8000
#define	I4321_TXCSR_QCLKINV	0x4000
#define	I4321_TXCSR_CRC32_EN	0x0200
#define	I4321_TXCSR_IDLE_EN	0x0100
#define	I4321_TXCSR_INT_EN	0x0080
#define	I4321_TXCSR_BUF_LAST_WR	0x0010
#define	I4321_TXCSR_BUF_CUR_TX	0x0008

#endif	/* __I4321_FPGA_H */
