#include "types.h"
#include "ctype.h"
#include "strings.h"
#include "stdio.h"
#include "logic.h"

extern struct promptlevel prompt_array[];
extern int promptlevel;

extern char *prompt();
extern int vc_config_start();

int nokia_data_rate;

nokia_flavor_confirm()
{
	char *answer;
	int stat;

	printf("\r\nPlease note that this DSU has some limitations\r\n");
	printf("with regard to Nokia flavor support:\r\n\r\n");
	printf("* The SDSL data rate needs to be configured explicitly by the user.\r\n");
	printf("  The standard flavor served by Covad has no pre-activation signal\r\n");
	printf("  and we don't \"hunt\" for the data rate by brute force trial like\r\n");
	printf("  the \"mainstream\" CPE devices do.\r\n\r\n");
	printf("* Our processor is unable to keep up with the higher Nokia SDSL speeds.\r\n");
	printf("  The highest Nokia data rate which we can support reliably is 768 kbps\r\n");
	printf("  on a 25 MHz board with no FPGA or 1152 kbps with the FPGA.\r\n");
	printf("  You can configure the DSU for higher speeds and the link will\r\n");
	printf("  come up, but operation will be erratic and likely unusable.\r\n\r\n");
	printf("Press Enter to continue or type BACK to go back\r\n");
	answer = prompt();
	stat = check_std_responses(answer);
	if (stat)
		return(stat);
	return(ACTION_CONTINUE);
}

nokia_config_datarate()
{
	char *answer;
	char *cfgptr;
	int stat, num;

loop:	cfgptr = prompt_array[promptlevel].config_ptr;
	printf("\r\nPlease specify the SDSL data rate in kbps: ");
	answer = prompt();
	stat = check_std_responses(answer);
	if (stat)
		return(stat);
	if (!is_string_num(answer)) {
		printf("Invalid entry\r\n");
		goto loop;
	}
	num = atoi(answer);
	if (num % 8 || num < 144 || num > 2320) {
		printf("Specified value is not a possible SDSL data rate\r\n");
		goto loop;
	}
	nokia_data_rate = num;
	cfgptr += sprintf(cfgptr, "data_rate=%d\n", num);
	prompt_array[promptlevel+1].func = vc_config_start;
	prompt_array[promptlevel+1].config_ptr = cfgptr;
	switch (num) {
	case 192:
	case 384:
	case 768:
	case 1152:
	case 1536:
	case 2320:
		return(ACTION_CONTINUE);
	default:
		stat = nokia_datarate_nonstd_confirm();
		if (stat == ACTION_BACK)
			goto loop;
		return(stat);
	}
}

nokia_datarate_nonstd_confirm()
{
	char *answer;
	int stat;

	printf("\r\nNokia's SDSL rate set is 192, 384, 768, 1152, 1536 and 2320 kbps.\r\n");
	printf("The data rate you've entered is not in this set.\r\n\r\n");
	printf("The data rate you configure on this DSU must exactly match the\r\n");
	printf("rate served to you by your service provider's DSLAM.\r\n");
	printf("Are you sure you've entered the correct data rate?\r\n\r\n");
	printf("Press Enter to continue or type BACK to go back\r\n");
	answer = prompt();
	stat = check_std_responses(answer);
	if (stat)
		return(stat);
	return(ACTION_CONTINUE);
}

nokia_autobaud_confirm()
{
	char *answer;
	int stat;

	printf("\r\nPlease note that Covad's lines have AutoBaud disabled, hence the\r\n");
	printf("Nokia AutoBaud configuration will NOT work on a Covad line.\r\n\r\n");
	printf("Press Enter to continue or type BACK to go back\r\n");
	answer = prompt();
	stat = check_std_responses(answer);
	if (stat)
		return(stat);
	return(ACTION_CONTINUE);
}
