#include "types.h"
#include "ctype.h"
#include "strings.h"
#include "stdio.h"
#include "rt11ffs.h"
#include "../flashw/api.h"
#include "monitor_api.h"
#include "logic.h"

extern struct flashw_api_table *fetch_flashw();

struct flashw_api_table *flashw_api;

char config_txt_buf[4096];
struct promptlevel prompt_array[64];
int promptlevel;
int nokia_l2conv;

extern int intro();

mymain()
{
	int (*fptr)(), stat;

	if (get_hwconf() < 0)
		return;
	flashw_api = fetch_flashw();
	if (!flashw_api)
		return;
	prompt_array[0].func = intro;
	prompt_array[0].config_ptr = config_txt_buf;
	promptlevel = 0;
	for (;;) {
		fptr = prompt_array[promptlevel].func;
		if (!fptr) {
			printf("Internal error: unfinished code\r\n");
			return;
		}
		stat = (*fptr)();
		switch (stat) {
		case ACTION_CONTINUE:
			promptlevel++;
			continue;
		case ACTION_BACK:
			if (!promptlevel) {
			    printf("Internal error: nowhere to go back!\r\n");
			    return;
			}
			promptlevel--;
			continue;
		case ACTION_STARTOVER:
			promptlevel = 0;
			continue;
		case ACTION_ABORT:
		default:
			printf("Aborting configuration process\r\n");
			return;
		case ACTION_EXIT:
			return;
		}
	}
}
