#include "types.h"
#include "ctype.h"
#include "strings.h"
#include "stdio.h"
#include "rt11ffs.h"
#include "logic.h"

extern struct promptlevel prompt_array[];
extern int promptlevel;

extern char *prompt();
extern int config_l2conv_scc2();

int vpi, vci;
char vclist_txt_buf[RT11FFS_AU_SIZE];

l2conv_config_dtr()
{
	char *answer;
	char *cfgptr;
	int stat;

	cfgptr = prompt_array[promptlevel].config_ptr;
loop:	printf("\r\nPlease select how you would like this DSU to react\r\n");
	printf("to the DTR modem control signal from the DTE.\r\n\r\n");
	printf("Available options:\r\n\r\n");
	printf("1: Ignore DTR: bring the SDSL link up irrespective of the state\r\n");
	printf("   of the attached router.\r\n");
	printf("2: Strictly obey DTR: attempt SDSL startup only if DTR is\r\n");
	printf("   asserted, immediate link teardown if DTR is negated.\r\n\r\n");
	printf("Option 1 is generally recommended in the Layer 2 converting DSU\r\n");
	printf("configuration, as having no packet traffic is not an error condition.\r\n\r\n");
	printf("Please make your selection: ");
	answer = prompt();
	stat = check_std_responses(answer);
	if (stat)
		return(stat);
	if (strlen(answer) != 1) {
inv:		printf("Invalid selection\r\n");
		goto loop;
	}
	switch (answer[0]) {
	case '1':
		cfgptr += sprintf(cfgptr, "obey_dtr=no\n");
		break;
	case '2':
		cfgptr += sprintf(cfgptr, "obey_dtr=yes\n");
		break;
	default:
		goto inv;
	}
	prompt_array[promptlevel+1].func = config_l2conv_scc2;
	prompt_array[promptlevel+1].config_ptr = cfgptr;
	return(ACTION_CONTINUE);
}

zeropad_vclist_txt()
{
	char *cp;

	cp = index(vclist_txt_buf, '\0');
	bzero(cp, RT11FFS_AU_SIZE - (cp - vclist_txt_buf));
}

show_vclist_txt()
{
	printf("VCLIST.TXT has been generated as follows:\r\n\r\n");
	dump_generated_text(vclist_txt_buf);
}

vc_config_rfc2364_llc()
{
	char *answer;
	int stat;

loop:	printf("\r\nThis DSU can handle the RFC 2364 LLC encapsulation\r\n");
	printf("in one of two ways:\r\n\r\n");
	printf("1: Convert to straight PPP (RFC 1662)\r\n");
	printf("2: Convert to RFC 1973 aka PPPoFR (FRF.8 conversion mode)\r\n");
	printf("\r\nPlease make your selection (1 or 2): ");
	answer = prompt();
	stat = check_std_responses(answer);
	if (stat)
		return(stat);
	if (strlen(answer) != 1) {
inv:		printf("Invalid selection\r\n");
		goto loop;
	}
	switch (answer[0]) {
	case '1':
		sprintf(vclist_txt_buf, "%d*%d PPP LLC=1\n", vpi, vci);
		zeropad_vclist_txt();
		prompt_array[promptlevel+1].func = l2conv_config_dtr;
		prompt_array[promptlevel+1].config_ptr =
					prompt_array[promptlevel].config_ptr;
		printf("\r\n");
		show_vclist_txt();
		stat = generic_confirm();
		if (stat == ACTION_BACK)
			goto loop;
		return(stat);
	case '2':
		sprintf(vclist_txt_buf, "%d*%d FRF.8 DLCI=16\n", vpi, vci);
		zeropad_vclist_txt();
		prompt_array[promptlevel+1].func = l2conv_config_dtr;
		prompt_array[promptlevel+1].config_ptr =
					prompt_array[promptlevel].config_ptr;
		printf("\r\n");
		show_vclist_txt();
		stat = generic_confirm();
		if (stat == ACTION_BACK)
			goto loop;
		return(stat);
	default:
		goto inv;
	}
}

vc_config_encap()
{
	char *answer;
	int stat;

loop:	printf("\r\nWe need to figure out what encapsulation your service provider is\r\n");
	printf("serving to you on this ATM VC.  Supported possibilities are:\r\n\r\n");
	printf("1: RFC 1483, LLC encapsulation, routed or bridged (FRF.8 conversion mode)\r\n");
	printf("2: RFC 1483, routed IPv4, VC based multiplexing (pseudo-FRF.8 conversion to FR)\r\n");
	printf("3: RFC 2364 (PPP over ATM), LLC encapsulation\r\n");
	printf("4: RFC 2364 (PPP over ATM), VC based multiplexing\r\n");
	printf("5: FR over ATM encapsulation aka FR-SSCS (FRF.5 conversion mode)\r\n");
	printf("\r\nPlease make your selection: ");
	answer = prompt();
	stat = check_std_responses(answer);
	if (stat)
		return(stat);
	if (strlen(answer) != 1) {
inv:		printf("Invalid selection\r\n");
		goto loop;
	}
	switch (answer[0]) {
	case '1':
		sprintf(vclist_txt_buf, "%d*%d FRF.8 DLCI=16\n", vpi, vci);
		zeropad_vclist_txt();
		prompt_array[promptlevel+1].func = l2conv_config_dtr;
		prompt_array[promptlevel+1].config_ptr =
					prompt_array[promptlevel].config_ptr;
		printf("\r\n");
		show_vclist_txt();
		stat = generic_confirm();
		if (stat == ACTION_BACK)
			goto loop;
		return(stat);
	case '2':
		sprintf(vclist_txt_buf, "%d*%d FRF.8 IPONLY=1 DLCI=16\n",
			vpi, vci);
		zeropad_vclist_txt();
		prompt_array[promptlevel+1].func = l2conv_config_dtr;
		prompt_array[promptlevel+1].config_ptr =
					prompt_array[promptlevel].config_ptr;
		printf("\r\n");
		show_vclist_txt();
		stat = generic_confirm();
		if (stat == ACTION_BACK)
			goto loop;
		return(stat);
	case '3':
		prompt_array[promptlevel+1].func = vc_config_rfc2364_llc;
		prompt_array[promptlevel+1].config_ptr =
					prompt_array[promptlevel].config_ptr;
		return(ACTION_CONTINUE);
	case '4':
		sprintf(vclist_txt_buf, "%d*%d PPP LLC=0\n", vpi, vci);
		zeropad_vclist_txt();
		prompt_array[promptlevel+1].func = l2conv_config_dtr;
		prompt_array[promptlevel+1].config_ptr =
					prompt_array[promptlevel].config_ptr;
		printf("\r\nThe DSU will be set up to convert RFC 2364 to straight PPP (RFC 1662)\r\n\r\n");
		show_vclist_txt();
		stat = generic_confirm();
		if (stat == ACTION_BACK)
			goto loop;
		return(stat);
	case '5':
		sprintf(vclist_txt_buf, "%d*%d FRF.5\n", vpi, vci);
		zeropad_vclist_txt();
		prompt_array[promptlevel+1].func = l2conv_config_dtr;
		prompt_array[promptlevel+1].config_ptr =
					prompt_array[promptlevel].config_ptr;
		printf("\r\n");
		show_vclist_txt();
		stat = generic_confirm();
		if (stat == ACTION_BACK)
			goto loop;
		return(stat);
	default:
		goto inv;
	}
}

vc_config_funi()
{
	char *answer;
	int stat;

loop:	printf("\r\nWould you like to use the FUNI conversion mode (Y/N)? ");
	answer = prompt();
	stat = check_std_responses(answer);
	if (stat)
		return(stat);
	switch (answer[0]) {
	case 'Y':
	case 'y':
		sprintf(vclist_txt_buf, "%d*%d FUNI\n", vpi, vci);
		zeropad_vclist_txt();
		prompt_array[promptlevel+1].func = l2conv_config_dtr;
		prompt_array[promptlevel+1].config_ptr =
					prompt_array[promptlevel].config_ptr;
		printf("\r\n");
		show_vclist_txt();
		stat = generic_confirm();
		if (stat == ACTION_BACK)
			goto loop;
		return(stat);
	case 'N':
	case 'n':
		prompt_array[promptlevel+1].func = vc_config_encap;
		prompt_array[promptlevel+1].config_ptr =
					prompt_array[promptlevel].config_ptr;
		return(ACTION_CONTINUE);
	default:
		printf("Invalid selection\r\n");
		goto loop;
	}
}

vc_config_vci()
{
	char *answer;
	int stat, num;

loop:	printf("\r\nPlease enter the VCI value for your ATM VC (0-65535): ");
	answer = prompt();
	stat = check_std_responses(answer);
	if (stat)
		return(stat);
	if (!is_string_num(answer)) {
inv:		printf("Invalid entry\r\n");
		goto loop;
	}
	num = atoi(answer);
	if (num > 65535)
		goto inv;
	vci = num;
	prompt_array[promptlevel+1].func = vc_config_funi;
	prompt_array[promptlevel+1].config_ptr =
					prompt_array[promptlevel].config_ptr;
	return(ACTION_CONTINUE);
}

vc_config_vpi()
{
	char *answer;
	int stat, num;

	printf("\r\nThis configuration wizard can only construct Layer 2 conversion\r\n");
	printf("configurations involving a single ATM VC.  If you have multiple\r\n");
	printf("ATM VCs provisioned over your SDSL pipe, you will need to create\r\n");
	printf("VCLIST.TXT manually.\r\n");
loop:	printf("\r\nPlease enter the VPI value for your ATM VC (0-255): ");
	answer = prompt();
	stat = check_std_responses(answer);
	if (stat)
		return(stat);
	if (!is_string_num(answer)) {
inv:		printf("Invalid entry\r\n");
		goto loop;
	}
	num = atoi(answer);
	if (num > 255)
		goto inv;
	vpi = num;
	prompt_array[promptlevel+1].func = vc_config_vci;
	prompt_array[promptlevel+1].config_ptr =
					prompt_array[promptlevel].config_ptr;
	return(ACTION_CONTINUE);
}

vc_config_start()
{
	char *answer;
	int stat;

loop:	printf("\r\nFor this SDSL flavor the DSU will act as a Layer 2 converter\r\n");
	printf("from SDSL/ATM to HDLC, therefore you need to configure how this\r\n");
	printf("conversion should be performed.\r\n\r\n");
	printf("Would you like to use the standard configuration for Covad (Y/N)? ");
	answer = prompt();
	stat = check_std_responses(answer);
	if (stat)
		return(stat);
	switch (answer[0]) {
	case 'Y':
	case 'y':
		vpi = 0;
		vci = 38;
		strcpy(vclist_txt_buf, "0*38 FRF.8 DLCI=16\n");
		zeropad_vclist_txt();
		prompt_array[promptlevel+1].func = l2conv_config_dtr;
		prompt_array[promptlevel+1].config_ptr =
					prompt_array[promptlevel].config_ptr;
		printf("\r\n");
		show_vclist_txt();
		stat = generic_confirm();
		if (stat == ACTION_BACK)
			goto loop;
		return(stat);
	case 'N':
	case 'n':
		prompt_array[promptlevel+1].func = vc_config_vpi;
		prompt_array[promptlevel+1].config_ptr =
					prompt_array[promptlevel].config_ptr;
		return(ACTION_CONTINUE);
	default:
		printf("Invalid selection\r\n");
		goto loop;
	}
}
