#include "types.h"
#include "ctype.h"
#include "strings.h"
#include "stdio.h"
#include "logic.h"

extern struct promptlevel prompt_array[];
extern int promptlevel;

extern char *prompt();
extern int finish();

bitdsu_config_dtr()
{
	char *answer;
	char *cfgptr;
	int stat;

	cfgptr = prompt_array[promptlevel].config_ptr;
loop:	printf("\r\nPlease select how you would like this DSU to react\r\n");
	printf("to the DTR modem control signal from the DTE.\r\n\r\n");
	printf("Available options:\r\n\r\n");
	printf("1: Ignore DTR and always strive to bring the SDSL link up,\r\n");
	printf("   even if the Tx bit stream is garbage.\r\n");
	printf("2: Strictly obey DTR: attempt SDSL startup only if DTR is\r\n");
	printf("   asserted, immediate link teardown if DTR is negated.\r\n");
	printf("3: (Cisco bug workaround mode) Require DTR before attempting\r\n");
	printf("   startup, tear link down if DTR is negated, but ignore\r\n");
	printf("   DTR transitions while startup is in progress.\r\n");
	printf("\r\nPlease make your selection: ");
	answer = prompt();
	stat = check_std_responses(answer);
	if (stat)
		return(stat);
	if (strlen(answer) != 1) {
inv:		printf("Invalid selection\r\n");
		goto loop;
	}
	switch (answer[0]) {
	case '1':
		cfgptr += sprintf(cfgptr, "obey_dtr=no\n");
		break;
	case '2':
		cfgptr += sprintf(cfgptr, "obey_dtr=yes\n");
		break;
	case '3':
		cfgptr += sprintf(cfgptr, "obey_dtr=yes\n");
		cfgptr += sprintf(cfgptr, "cisco_dtr_bug=yes\n");
		break;
	default:
		goto inv;
	}
	prompt_array[promptlevel+1].func = finish;
	prompt_array[promptlevel+1].config_ptr = cfgptr;
	return(ACTION_CONTINUE);
}

bitdsu_config_invert()
{
	char *answer;
	char *cfgptr;
	int stat;

	cfgptr = prompt_array[promptlevel].config_ptr;
loop:	printf("\r\nDoes your SDSL flavor use data inversion?\r\n\r\n");
	printf("To our knowledge data inversion was used by default by the\r\n");
	printf("Ascend/Lucent flavor, but not by any others.  If unsure,\r\n");
	printf("say N.\r\n\r\n");
	printf("Please enter Y or N: ");
	answer = prompt();
	stat = check_std_responses(answer);
	if (stat)
		return(stat);
	switch (answer[0]) {
	case 'Y':
	case 'y':
		cfgptr += sprintf(cfgptr, "data_invert=yes\n");
		break;
	case 'N':
	case 'n':
		break;
	default:
		printf("Invalid selection\r\n");
		goto loop;
	}
	prompt_array[promptlevel+1].func = bitdsu_config_dtr;
	prompt_array[promptlevel+1].config_ptr = cfgptr;
	return(ACTION_CONTINUE);
}

bitdsu_config_quat_orient()
{
	char *answer;
	char *cfgptr;
	int stat;

	cfgptr = prompt_array[promptlevel].config_ptr;
loop:	printf("\r\nIn the 2B1Q line code used by SDSL each electrical signal\r\n");
	printf("element has a sign and a magnitude, i.e., 4 possible states\r\n");
	printf("encoding 2 bits.  Half of the payload data bits are carried\r\n");
	printf("in the sign bit and the other half are carried in the magnitude bit.\r\n");
	printf("Unfortunately different SDSL flavors have set different and incompatible\r\n");
	printf("conventions as to which bit goes first.  You need to select\r\n");
	printf("one of two possible configurations:\r\n\r\n");
	printf("1: Sign bit first, then magnitude bit\r\n");
	printf("2: Magnitude bit first, then sign bit\r\n");
	printf("\r\nPlease make your selection: ");
	answer = prompt();
	stat = check_std_responses(answer);
	if (stat)
		return(stat);
	if (strlen(answer) != 1) {
inv:		printf("Invalid selection\r\n");
		goto loop;
	}
	switch (answer[0]) {
	case '1':
		cfgptr += sprintf(cfgptr, "quat_orient=signfirst\n");
		break;
	case '2':
		cfgptr += sprintf(cfgptr, "quat_orient=magfirst\n");
		break;
	default:
		goto inv;
	}
	prompt_array[promptlevel+1].func = bitdsu_config_invert;
	prompt_array[promptlevel+1].config_ptr = cfgptr;
	return(ACTION_CONTINUE);
}

bitdsu_config_datarate()
{
	char *answer;
	char *cfgptr;
	int stat, num;

loop:	cfgptr = prompt_array[promptlevel].config_ptr;
	printf("\r\nPlease specify the SDSL data rate in kbps: ");
	answer = prompt();
	stat = check_std_responses(answer);
	if (stat)
		return(stat);
	if (!is_string_num(answer)) {
		printf("Invalid entry\r\n");
		goto loop;
	}
	num = atoi(answer);
	if (num % 8 || num < 144 || num > 2320) {
		printf("Specified value is not a possible SDSL data rate\r\n");
		goto loop;
	}
	cfgptr += sprintf(cfgptr, "data_rate=%d\n", num);
	prompt_array[promptlevel+1].func = bitdsu_config_quat_orient;
	prompt_array[promptlevel+1].config_ptr = cfgptr;
	switch (num) {
	case 144:
	case 160:
	case 192:
	case 208:
	case 272:
	case 288:
	case 320:
	case 384:
	case 392:
	case 400:
	case 416:
	case 528:
	case 768:
	case 784:
	case 1040:
	case 1152:
	case 1168:
	case 1536:
	case 1552:
	case 1568:
	case 2320:
		return(ACTION_CONTINUE);
	default:
		stat = stur_datarate_confirm();
		if (stat == ACTION_BACK)
			goto loop;
		return(stat);
	}
}

stur_datarate_confirm()
{
	char *answer;
	int stat;

	printf("\r\nThe data rate you've entered is not a standard SDSL data\r\n");
	printf("rate to our knowledge.  The data rate you configure on this\r\n");
	printf("DSU must exactly match the rate served to you by your service\r\n");
	printf("provider's DSLAM.  Are you sure you've entered the correct\r\n");
	printf("data rate?\r\n\r\n");
	printf("Press Enter to continue or type BACK to go back\r\n");
	answer = prompt();
	stat = check_std_responses(answer);
	if (stat)
		return(stat);
	return(ACTION_CONTINUE);
}

bitdsu_config_other()
{
	char *answer;
	char *cfgptr;
	int stat;

loop:	cfgptr = prompt_array[promptlevel].config_ptr;
	printf("\r\nConfiguring for bit-transparent DSU operation without\r\n");
	printf("CM or IFCTF pre-activation.  The remaining pre-activation\r\n");
	printf("choices are Conexant/Mindspeed AutoBaud and none.\r\n\r\n");
	printf("If you select AutoBaud, the DSU will wait for AutoBaud\r\n");
	printf("messages and act upon them to our best understanding of\r\n");
	printf("this protocol.  If you select no pre-activation, you will\r\n");
	printf("need to explicitly configure the data rate and the quat\r\n");
	printf("orientation setting; the DSU won't listen for any type of\r\n");
	printf("pre-activation signal.\r\n\r\n");
	printf("Do you want to enable AutoBaud HTU-R operation (Y/N)? ");
	answer = prompt();
	stat = check_std_responses(answer);
	if (stat)
		return(stat);
	switch (answer[0]) {
	case 'Y':
	case 'y':
		cfgptr += sprintf(cfgptr, "preact_type=AutoBaud\n");
		prompt_array[promptlevel+1].func = bitdsu_config_invert;
		prompt_array[promptlevel+1].config_ptr = cfgptr;
		stat = bitdsu_autobaud_confirm();
		if (stat == ACTION_BACK)
			goto loop;
		return(stat);
	case 'N':
	case 'n':
		cfgptr += sprintf(cfgptr, "preact_type=none\n");
		prompt_array[promptlevel+1].func = bitdsu_config_datarate;
		prompt_array[promptlevel+1].config_ptr = cfgptr;
		return(ACTION_CONTINUE);
	default:
		printf("Invalid selection\r\n");
		goto loop;
	}
}

bitdsu_autobaud_confirm()
{
	char *answer;
	int stat;

	printf("\r\nSupport for the AutoBaud protocol on this open source\r\n");
	printf("DSU is still very experimental, particularly with regard\r\n");
	printf("to the interpretation of the flavor ID bytes.  No guarantees\r\n");
	printf("are made that this AutoBaud implementation will work correctly\r\n");
	printf("with any given SDSL flavor out in the wild.\r\n\r\n");
	printf("If you are dealing with an SDSL flavor that uses AutoBaud,\r\n");
	printf("we ask that you please report your experiences with it (either\r\n");
	printf("good or bad) along with a startup terminal output log to the\r\n");
	printf("Open WAN Connectivity Project.\r\n\r\n");
	printf("Press Enter to continue or type BACK to go back\r\n");
	answer = prompt();
	stat = check_std_responses(answer);
	if (stat)
		return(stat);
	return(ACTION_CONTINUE);
}
