/*
 * BER meter support
 */

#include "types.h"
#include "stdio.h"
#include "ctype.h"
#include "strings.h"
#include "console.h"
#include "../lib8973/typedefs.h"
#include "../lib8973/bitpump.h"
#include "../lib8973/bpstate.h"
#include "../lib8973/bermeter.h"

struct ber_meter_state berstate;

cmd_ber_start(cmd)
	char *cmd;
{
	DECLARE_PTR;
	int s;

	if (parse_cmd(cmd, 0, 0, NULL, NULL, NULL, NULL))
		return(0);
	s = splup(1);
	BP_global_state.meter_tmr_inthandler = ber_meter_inthandler;
	BP_global_state.meter_tmr_inthandler_param = (u_long) &berstate;
	bp_ptr->mask_low_reg &= ~TIMERMASK_METER;
	bp_ptr->timer_source = ~TIMERMASK_METER;
	BP_global_state.latched_timer_irq &= ~TIMERMASK_METER;
	splx(s);
	return(0);
}

cmd_ber_stop(cmd)
	char *cmd;
{
	if (parse_cmd(cmd, 0, 0, NULL, NULL, NULL, NULL))
		return(0);
	BP_global_state.meter_tmr_inthandler = NULL;
	return(0);
}

cmd_ber_status(cmd)
	char *cmd;
{
	if (parse_cmd(cmd, 0, 0, NULL, NULL, NULL, NULL))
		return(0);
	printf("Bit errors: %lu\r\n", berstate.bit_errors);
	printf("Meter intervals: %lu\r\n", berstate.meter_intervals);
	return(0);
}

cmd_ber_zero(cmd)
	char *cmd;
{
	int s;

	if (parse_cmd(cmd, 0, 0, NULL, NULL, NULL, NULL))
		return(0);
	s = splup(1);
	bzero(&berstate, sizeof berstate);
	splx(s);
	return(0);
}

static const struct keyword ber_subcmds[] = {
	{"CLEAR", 1, (long) &cmd_ber_zero},
	{"START", 4, (long) &cmd_ber_start},
	{"STATUS", 4, (long) &cmd_ber_status},
	{"STOP", 3, (long) &cmd_ber_stop},
	{"ZERO", 1, (long) &cmd_ber_zero},
	{NULL, 0, -1}};

cmd_ber(cmd)
	char *cmd;
{
	char *cp = cmd, *subcmd;
	int count;
	void (*subcmdfunc)();
	int ambigsubcmd;

	while (*cp == ' ')
		cp++;
	if (!issym(*cp)) {
		error("Subcommand required");
		return(0);
	}
	for (subcmd = cp, count = 0; issym(*cp); cp++)
		count++;
	ambigsubcmd = 0;
	subcmdfunc = (void (*)())
			find_keyword(subcmd, count, ber_subcmds, &ambigsubcmd);
	if ((long) subcmdfunc != -1)
		(*subcmdfunc)(cp);
	else {
		if (ambigsubcmd)
			error("Ambiguous subcommand");
		else
			error("Illegal subcommand");
	}
	return(0);
}
