#include "types.h"
#include "stdio.h"
#include "mc68302.h"
#include "gpio.h"
#include "monitor_api.h"
#include "sdsl_asm.h"
#include "../sdcore/api.h"
#include "../sdcore/state.h"
#include "../opcore/api.h"
#include "globals.h"

extern volatile struct mc68302_regs mc68302_regs;
extern volatile long timebase;

extern struct sdcore_api *fetch_sdcore();
extern struct opcore_api *fetch_opcore();
extern caddr_t malloc();

static const u_short appname[2] = {0x0DFC, 0x1C0D};

init()
{
	printf("\r\nBit-transparent DSU operational code running\r\n");
	if (sdcore_init() < 0)
		return(-1);
	opcore_api = fetch_opcore();
	if (!opcore_api) {
		/* error message already printed */
		return(-1);
	}
	if (opcore_api->init(appname, sdcore_api, &sdcore_state) < 0)
		return(-1);
	if (get_config() < 0)
		return(-1);
	if (set_muxes() < 0)
		return(-1);
	register_custom_craft_commands();
	sdsl_asm_state = INACTIVE_STATE;
	timebase = 0;
	return(0);
}

sdcore_init()
{
	caddr_t privstate;

	sdcore_api = fetch_sdcore();
	if (!sdcore_api) {
		/* error message already printed */
		return(-1);
	}
	privstate = malloc(sdcore_api->sizeof_privstate);
	sdcore_api->swinit(&sdcore_state, privstate);
	return(0);
}

set_muxes()
{
	char *s;
	int invert;
	u_short porta;

	s = opcore_api->config_search("data_invert");
	if (!s) {
		invert = 0;	/* default is no inversion of course */
		goto act;
	}
	invert = opcore_api->parse_boolean_param(s);
	if (invert < 0) {
		monapi_error("data_invert=%s: invalid setting", s);
		return(-1);
	}
act:	porta = mc68302_regs.padat;
	porta &= ~PORTA_TXMUX_MASK;
	porta &= ~PORTA_DCEMUX_MASK;
	if (!invert) {
		porta |= PORTA_TXMUX_DCE;
		porta |= PORTA_DCEMUX_SDSL;
	} else {
		porta |= PORTA_TXMUX_DCEINV;
		porta |= PORTA_DCEMUX_SDSLINV;
	}
	mc68302_regs.padat = porta;
	return(0);
}
