/*
 * BITDSU-specific craft terminal commands
 */

#include "types.h"
#include "ctype.h"
#include "stdio.h"
#include "strings.h"
#include "sdsl_asm.h"
#include "../lib8973/bpstate.h"
#include "../sdcore/api.h"
#include "../sdcore/state.h"
#include "../opcore/api.h"
#include "globals.h"

extern volatile long timebase;

extern char *sdsl_asm_states[];

cmd_retrain()
{
	switch (sdsl_asm_state) {
	case ACTIVATING_STATE:
	case ACTIVE_STATE:
		set_sdsl_state(DEACTIVATED_STATE);
		break;
	default:
		printf("RETRAIN command ignored in %s\r\n",
			sdsl_asm_states[sdsl_asm_state]);
	}
}

cmd_rtsovr(arg)
	char *arg;
{
	char *cp, *np;

	for (cp = arg; isspace(*cp); cp++)
		;
	if (!*cp) {
inv:		printf("Syntax error: ON or OFF keyword required\r\n");
		return;
	}
	for (np = cp; *cp && !isspace(*cp); cp++)
		;
	if (*cp)
		*cp++ = '\0';
	if (!strcasecmp(np, "ON"))
		rts_override = 1;
	else if (!strcasecmp(np, "OFF"))
		rts_override = 0;
	else
		goto inv;
}

cmd_speed(arg)
	char *arg;
{
	char *cp, *np;
	int val;

	if (sdcore_state.terminal_type && sdcore_state.preact_type) {
	 printf("SPEED command not supported on STU-R with pre-activation\r\n");
		return;
	}
	for (cp = arg; isspace(*cp); cp++)
		;
	if (!*cp) {
inv:		printf("Syntax error: numeric argument required\r\n");
		return;
	}
	for (np = cp; *cp && !isspace(*cp); cp++)
		;
	if (*cp)
		*cp++ = '\0';
	if (!opcore_api->is_string_num(np))
		goto inv;
	val = atoi(np);
	if (!sdcore_api->datarate_issup(val)) {
		printf("Requested speed is not a valid SDSL data rate\r\n");
		return;
	}
	/* do it! */
	sdcore_state.user_data_rate = val >> 3;
	if (sdsl_asm_state == ACTIVATING_STATE ||
	    sdsl_asm_state == ACTIVE_STATE)
		set_sdsl_state(DEACTIVATED_STATE);
}

static
paren_bit_output(flg, text, latch)
	int flg, *latch;
	char *text;
{
	if (!flg)
		return;
	printf("%s%s", *latch ? ", " : " (", text);
	*latch = 1;
}

cmd_show_status()
{
	u_char stat;
	int latch = 0;

	opcore_api->print_timeint("DSU uptime", timebase);
	printf("SDSL ASM state: %s (link %s)\r\n",
		sdsl_asm_states[sdsl_asm_state],
		sdsl_asm_state == ACTIVE_STATE ? "up" : "down");
	if (sdsl_asm_state == ACTIVE_STATE) {
		opcore_api->print_timeint("Link uptime",
					  timebase - sdsl_asm_state_time);
		printf("Active data rate: %u kbps\r\n",
			sdcore_state.user_data_rate << 3);
	} else
		printf("BCLK ticking @ %u kbps\r\n",
			BP_global_state.symbol_rate << 3);
	stat = sdcore_state.status.byte;
	printf("SDCORE status: %02X", stat);
	paren_bit_output(stat & 0x80, "Normal op", &latch);
	paren_bit_output(stat & 0x40, "Tx 4-level", &latch);
	paren_bit_output(stat & 0x20, "LOST running", &latch);
	paren_bit_output(stat & 0x10, "Preact done", &latch);
	paren_bit_output(stat & 0x08, "Timer expired", &latch);
	paren_bit_output(stat & 0x04, "T/R rev", &latch);
	paren_bit_output(stat & 0x02, "LOST", &latch);
	paren_bit_output(stat & 0x01, "LOS", &latch);
	printf("%s\r\n", latch ? ")" : "");
	return(0);
}

register_custom_craft_commands()
{
	opcore_api->register_craft_command("RETRAIN", 7, cmd_retrain);
	opcore_api->register_craft_command("SPEED", 5, cmd_speed);
	opcore_api->register_craft_command("RTSOVR", 6, cmd_rtsovr);
	opcore_api->register_show_subcmd("STATUS", 4, cmd_show_status);
	return(0);
}
