#include "types.h"
#include "ctype.h"
#include "strings.h"
#include "stdio.h"
#include "monitor_api.h"
#include "../sdcore/api.h"
#include "../sdcore/state.h"
#include "../opcore/api.h"
#include "globals.h"

get_config()
{
	int i;

	i = opcore_api->get_ttype();
	if (i < 0)
		return(i);
	i = opcore_api->get_preact_type();
	if (i < 0)
		return(i);
	if (!sdcore_state.terminal_type || !sdcore_state.preact_type) {
		i = opcore_api->get_datarate();
		if (i < 0)
			return(i);
	}
	i = opcore_api->get_quat_orient();
	if (i < 0)
		return(i);
	if (!sdcore_state.terminal_type &&
	    sdcore_state.preact_type == PREACT_TYPE_AUTOBAUD) {
		i = opcore_api->get_ab_flavor();
		if (i < 0)
			return(i);
	}
	i = get_nmr_th();
	if (i < 0)
		return(i);
	i = get_pend_gracetime();
	if (i < 0)
		return(i);
	i = get_lost_timeout();
	if (i < 0)
		return(i);
	i = init_rts_override();
	if (i < 0)
		return(i);
	i = get_cisco_dtr_bug();
	if (i < 0)
		return(i);
	return(0);
}

get_nmr_th()
{
	char *s, *cp;
	int minus = 0, val;

	s = opcore_api->config_search("nmr_threshold");
	if (!s) {
		/* HDSL/Brooktree default */
		nmr_threshold = -10;	/* -5 dB */
		nmr_threshold_set = 1;
		return(0);
	}
	if (!strcasecmp(s, "none")) {
		nmr_threshold_set = 0;
		return(0);
	}
	cp = s;
	if (*cp == '-') {
		minus = 1;
		cp++;
	} else if (*cp == '+')
		cp++;
	if (!isdigit(*cp)) {
inv:		monapi_error("nmr_threshold=%s: invalid setting", s);
		return(-1);
	}
	for (val = 0; isdigit(*cp); ) {
		val *= 10;
		val += *cp++ - '0';
	}
	val <<= 1;
	if (*cp == '.') {
		cp++;
		if (*cp == '5')
			val++;
		else if (*cp == '0')
			;
		else
			goto inv;
		if (*++cp)
			goto inv;
	} else if (*cp)
		goto inv;
	if (minus)
		val = -val;
	nmr_threshold = val;
	nmr_threshold_set = 1;
	return(0);
}

get_pend_gracetime()
{
	char *s;
	int val;

	s = opcore_api->config_search("pending_deact_gracetime");
	if (!s) {
		val = 40;	/* 2 s default */
		goto set;
	}
	if (!opcore_api->is_string_num(s)) {
		monapi_error("pending_deact_gracetime=%s: invalid setting", s);
		return(-1);
	}
	val = atoi(s);
set:	pending_deact_gracetime = val;
	return(0);
}

get_lost_timeout()
{
	char *s;
	int val;

	s = opcore_api->config_search("los_lost_timeout");
	if (!s) {
		val = 30;	/* 30 s default */
		goto set;
	}
	if (!opcore_api->is_string_num(s)) {
		monapi_error("los_lost_timeout=%s: invalid setting", s);
		return(-1);
	}
	val = atoi(s);
set:	los_lost_timeout = val * 20;
	return(0);
}

init_rts_override()
{
	char *s;
	int bool;

	s = opcore_api->config_search("obey_rts");
	if (!s) {
		bool = 0;	/* default NOT to obey */
		goto act;
	}
	bool = opcore_api->parse_boolean_param(s);
	if (bool < 0) {
		monapi_error("obey_rts=%s: invalid setting", s);
		return(-1);
	}
act:	rts_override = !bool;
	return(0);
}

get_cisco_dtr_bug()
{
	char *s;
	int bool;

	s = opcore_api->config_search("cisco_dtr_bug");
	if (!s) {
		cisco_dtr_bug = 0;	/* default no bug */
		return(0);
	}
	bool = opcore_api->parse_boolean_param(s);
	if (bool < 0) {
		monapi_error("cisco_dtr_bug=%s: invalid setting", s);
		return(-1);
	}
	cisco_dtr_bug = bool;
	return(0);
}
