module FPGA (M68K_addr, M68K_data, URDS, LRDS, UWRS, LWRS, CS_L, IRQ_L,
	BCLK, QCLK, SDSL_RDAT, SDSL_TDAT, DCE_TxD, DCE_RxD,
	CCITT_113, CCITT_114, CCITT_115, RxAM, TxAM, dummy_inputs);

input [12:1] M68K_addr;
inout [15:0] M68K_data;
input URDS, LRDS, UWRS, LWRS;
input CS_L;
output IRQ_L;

input BCLK;
input QCLK;
input SDSL_RDAT;
output SDSL_TDAT;
input DCE_TxD;
output DCE_RxD;

input CCITT_113;
output CCITT_114;
output CCITT_115;

output RxAM;
input TxAM;

input [2:0] dummy_inputs;

/* M68K address space decoding */

wire reg_block_select, ram_block_select;

assign reg_block_select = !CS_L && !M68K_addr[12];
assign ram_block_select = !CS_L && M68K_addr[12];

/* Wires between blocks */

wire reset_control, QCLK_control, int_en_ctrl, host_buf_ctrl, tx_buf_sense;

assign tx_buf_sense = 1'b0;

wire [15:0] M68K_reg_read_data;

wire [9:0] backend_read_addr;
wire [7:0] backend_read_data;

assign backend_read_addr = 10'b0;

/* Block instantiations */

regblock regblock (M68K_addr, M68K_data, UWRS, LWRS, reg_block_select,
	M68K_reg_read_data,
	reset_control, QCLK_control, int_en_ctrl, host_buf_ctrl, tx_buf_sense);

ramblock ramblock (M68K_addr[9:1], M68K_data, UWRS, LWRS, ram_block_select,
	backend_read_addr, backend_read_data);

/* Driving the bidirectional M68K data bus */

wire [15:0] M68K_data_out;

assign M68K_data_out = M68K_reg_read_data;

assign M68K_data[15:8] = !CS_L && !URDS ? M68K_data_out[15:8] : 8'bzzzzzzzz;
assign M68K_data[7:0]  = !CS_L && !LRDS ? M68K_data_out[7:0]  : 8'bzzzzzzzz;

/* Unused outputs */
assign IRQ_L = 1'b1;
assign SDSL_TDAT = 1'b1;
assign DCE_RxD = 1'b1;
assign CCITT_114 = 1'b0;
assign CCITT_115 = 1'b0;
assign RxAM = 1'b0;

endmodule
