/*
 * Register layout for the Nokia frame transmitter:
 *
 * offset 00: FPGA ID word
 * offset 02: CSR
 *
 * CSR bit assignments:
 *
 * <15>	Reset
 * <14>	QCLK invert
 * <7>	Interrupt enable
 * <4>	Buffer last written
 * <3>	Buffer currently transmitted
 */

module regblock (M68K_addr, M68K_data_in, UWRS, LWRS, block_select,
	M68K_reg_read_data,
	reset_control, QCLK_control, int_en_ctrl, host_buf_ctrl, tx_buf_sense);

input [12:1] M68K_addr;
input [15:0] M68K_data_in;
input UWRS, LWRS;
input block_select;

output [15:0] M68K_reg_read_data;
reg [15:0] M68K_reg_read_data;

output reset_control, QCLK_control, int_en_ctrl, host_buf_ctrl;
reg reset_control, QCLK_control, int_en_ctrl, host_buf_ctrl;
input tx_buf_sense;

/* Register initialization */
initial
begin
	reset_control = 1;
	QCLK_control = 0;
	int_en_ctrl = 0;
	host_buf_ctrl = 0;
end

/* Register write logic */

always @(posedge UWRS)
	if (block_select && M68K_addr[1])
	begin
		reset_control <= M68K_data_in[15];
		QCLK_control <= M68K_data_in[14];
	end

always @(posedge LWRS)
	if (block_select && M68K_addr[1])
	begin
		int_en_ctrl <= M68K_data_in[7];
		host_buf_ctrl <= M68K_data_in[4];
	end

/* Register read logic */

always @*
	if (M68K_addr[1])
	begin
		M68K_reg_read_data[15] = reset_control;
		M68K_reg_read_data[14] = QCLK_control;
		M68K_reg_read_data[13] = 1'b0;
		M68K_reg_read_data[12] = 1'b0;
		M68K_reg_read_data[11] = 1'b0;
		M68K_reg_read_data[10] = 1'b0;
		M68K_reg_read_data[9] = 1'b0;
		M68K_reg_read_data[8] = 1'b0;
		M68K_reg_read_data[7] = int_en_ctrl;
		M68K_reg_read_data[6] = 1'b0;
		M68K_reg_read_data[5] = 1'b0;
		M68K_reg_read_data[4] = host_buf_ctrl;
		M68K_reg_read_data[3] = tx_buf_sense;
		M68K_reg_read_data[2] = 1'b0;
		M68K_reg_read_data[1] = 1'b0;
		M68K_reg_read_data[0] = 1'b0;
	end else
		M68K_reg_read_data = 16'h5254;

endmodule
