/*
 * Here we implement a 1024 byte buffer which is written by the M68K core
 * and read by the SDSL frame transmitter block.  The write path is the 16-bit
 * M68K data bus; the read path is 8 bits wide.  The internal implementation
 * uses two 512x8 RAM blocks: one for the even half and one for the odd half.
 */

module ramblock (M68K_addr, M68K_data_in, UWRS, LWRS, block_select,
	read_addr, read_data);

input [9:1] M68K_addr;
input [15:0] M68K_data_in;
input UWRS, LWRS;
input block_select;

input [9:0] read_addr;
output [7:0] read_data;

/* actual RAM blocks */
reg [7:0] evenram[0:511];
reg [7:0] oddram[0:511];

/* Write logic */

always @(posedge UWRS)
	if (block_select)
		evenram[M68K_addr] <= M68K_data_in[15:8];

always @(posedge LWRS)
	if (block_select)
		oddram[M68K_addr] <= M68K_data_in[7:0];

/* Read logic */

wire [7:0] evenram_read_bus, oddram_read_bus;

assign evenram_read_bus = evenram[read_addr[9:1]];
assign oddram_read_bus = oddram[read_addr[9:1]];

assign read_data = read_addr[0] ? oddram_read_bus : evenram_read_bus;

endmodule
