module FPGA (SYSCLK, M68K_addr, M68K_data, URDS, LRDS, UWRS, LWRS, CS_L, IRQ_L,
	BCLK, QCLK, SDSL_RDAT, SDSL_TDAT, DCE_TxD, DCE_RxD,
	CCITT_114, CCITT_115, RxAM, TxAM, dummy_inputs);

input SYSCLK;
input [12:1] M68K_addr;
inout [15:0] M68K_data;
input URDS, LRDS, UWRS, LWRS;
input CS_L;
output IRQ_L;

input BCLK;
input QCLK;
input SDSL_RDAT;
output SDSL_TDAT;
input DCE_TxD;
output DCE_RxD;

output CCITT_114;
output CCITT_115;

output RxAM;
input TxAM;

input [2:0] dummy_inputs;

/* M68K address space decoding */

wire reg_block_select, ram_block_select;

assign reg_block_select = !CS_L && !M68K_addr[12];
assign ram_block_select = !CS_L && M68K_addr[12];

/* Wires between blocks */

wire reset_control, QCLK_control, int_en_ctrl, host_buf_ctrl, tx_buf_sense;
wire effective_QCLK;
wire crc32_enable, idlecell_enable;

assign effective_QCLK = QCLK ^ QCLK_control;

wire [15:0] M68K_reg_read_data, M68K_ram_read_data;

wire [9:0] backport_read_addr;
wire [7:0] backport_read_data;

assign tx_buf_sense = backport_read_addr[9];

/* Block instantiations */

regblock regblock (SYSCLK, M68K_addr, M68K_data, UWRS, LWRS, reg_block_select,
	M68K_reg_read_data,
	reset_control, QCLK_control, int_en_ctrl, host_buf_ctrl, tx_buf_sense,
	crc32_enable, idlecell_enable);

ram16 ram16 (SYSCLK, M68K_addr[9:1], M68K_data, UWRS, LWRS, ram_block_select,
	M68K_ram_read_data, backport_read_addr, backport_read_data);

xmitter xmitter (backport_read_addr, backport_read_data, BCLK, effective_QCLK,
	SDSL_TDAT, reset_control, crc32_enable, idlecell_enable);

/* Driving the bidirectional M68K data bus */

wire [15:0] M68K_data_out;

assign M68K_data_out = M68K_addr[12] ? M68K_ram_read_data : M68K_reg_read_data;

assign M68K_data[15:8] = !CS_L && !URDS ? M68K_data_out[15:8] : 8'bzzzzzzzz;
assign M68K_data[7:0]  = !CS_L && !LRDS ? M68K_data_out[7:0]  : 8'bzzzzzzzz;

/* Interrupt output */

assign IRQ_L = !((host_buf_ctrl == tx_buf_sense) && int_en_ctrl);

/* Unused outputs */
assign DCE_RxD = 1'b1;
assign CCITT_114 = 1'b0;
assign CCITT_115 = 1'b0;
assign RxAM = 1'b0;

endmodule
