/*
 * Here we implement a 1024 byte buffer which is written by the M68K core
 * and read by the SDSL frame transmitter block.  The write path is the 16-bit
 * M68K data bus; the read path is 8 bits wide.  The internal implementation
 * uses two 512x8 RAM blocks: one for the even half and one for the odd half.
 */

module ram16 (SYSCLK, M68K_addr, M68K_data_in, UWRS, LWRS, block_select,
	M68K_data_out, backport_read_addr, backport_read_data);

input SYSCLK;
input [9:1] M68K_addr;
input [15:0] M68K_data_in;
input UWRS, LWRS;
input block_select;
output [15:0] M68K_data_out;

input [9:0] backport_read_addr;
output [7:0] backport_read_data;

wire [7:0] host_read_data_hi, backport_read_data_hi;
wire [7:0] host_read_data_lo, backport_read_data_lo;

ramblock ramblk_hi (SYSCLK, M68K_addr, M68K_data_in[15:8], block_select, !UWRS,
	host_read_data_hi, backport_read_addr[9:1], backport_read_data_hi);

ramblock ramblk_lo (SYSCLK, M68K_addr, M68K_data_in[7:0], block_select, !LWRS,
	host_read_data_lo, backport_read_addr[9:1], backport_read_data_lo);

assign M68K_data_out = {host_read_data_hi,host_read_data_lo};

assign backport_read_data = backport_read_addr[0] ? backport_read_data_lo
						  : backport_read_data_hi;

endmodule
