/*
 * This logic block is tacked on after the main Tx engine
 * and implements Tx side SSS scrambling.
 */

module txsss (SSS_enable, BCLK, ATMout, is_payload, SDSLout);

input SSS_enable;
input BCLK, ATMout, is_payload;
output SDSLout;
reg SDSLout;

reg [42:0] SSS_reg;

always @(posedge BCLK)
	if (is_payload)
		SSS_reg <= {SSS_reg[41:0],SSS_reg[42] ^ ATMout};

always @(posedge BCLK)
	if (SSS_enable && is_payload)
		SDSLout <= SSS_reg[42] ^ ATMout;
	else
		SDSLout <= ATMout;

endmodule
