/*
 * This is a wrapper around altsyncram for a Tx buffer RAM block.
 */

module txramblock (SYSCLK, host_addr, host_data_in, block_select, write_strobe,
	host_data_out, backport_read_addr, backport_data_out);

input SYSCLK;
input [7:0] host_addr;
input [7:0] host_data_in;
input block_select, write_strobe;
output [7:0] host_data_out;

input [7:0] backport_read_addr;
output [7:0] backport_data_out;
reg [7:0] backport_data_out;

wire [7:0] addr_to_ramblock;
wire ramblock_wren;
wire [7:0] raw_data_out;

assign addr_to_ramblock = block_select ? host_addr : backport_read_addr;
assign ramblock_wren = block_select && write_strobe;

altsyncram ramcore (.data_a(host_data_in), .address_a(addr_to_ramblock),
		.wren_a(ramblock_wren), .q_a(raw_data_out), .clock0(SYSCLK));

defparam
	ramcore.operation_mode = "SINGLE_PORT",
	ramcore.width_a = 8,
	ramcore.widthad_a = 8,
	ramcore.numwords_a = 256,
	ramcore.outdata_reg_a = "UNREGISTERED";

assign host_data_out = raw_data_out;

reg latched_read_is_for_backport;

always @(posedge SYSCLK)
	latched_read_is_for_backport <= !block_select;

always @(posedge SYSCLK)
	if (latched_read_is_for_backport)
		backport_data_out <= raw_data_out;

endmodule
