/*
 * This is a wrapper around altsyncram for an Rx buffer RAM block.
 */

module rxramblock (SYSCLK, host_rd_addr, block_select, host_data_out,
	bp_write_request, bp_write_done, bp_write_addr, bp_write_data);

input SYSCLK;
input [8:0] host_rd_addr;
input block_select;
output [7:0] host_data_out;

input [8:0] bp_write_addr;
input [7:0] bp_write_data;
input bp_write_request;
output bp_write_done;
reg bp_write_done;

wire [8:0] addr_to_ramblock;
wire ramblock_wren;
reg block_select_latch;
wire effective_block_select;

always @(posedge SYSCLK)
	block_select_latch <= block_select;

assign effective_block_select = block_select && !block_select_latch;

assign addr_to_ramblock = effective_block_select ? host_rd_addr : bp_write_addr;
assign ramblock_wren = !effective_block_select && bp_write_request &&
			!bp_write_done;

altsyncram ramcore (.data_a(bp_write_data), .address_a(addr_to_ramblock),
		.wren_a(ramblock_wren), .q_a(host_data_out), .clock0(SYSCLK));

defparam
	ramcore.operation_mode = "SINGLE_PORT",
	ramcore.width_a = 8,
	ramcore.widthad_a = 9,
	ramcore.numwords_a = 512,
	ramcore.outdata_reg_a = "CLOCK0";

always @(posedge SYSCLK)
	if (!bp_write_request)
		bp_write_done <= 1'b0;
	else if (ramblock_wren)
		bp_write_done <= 1'b1;

endmodule
