module rxram16 (SYSCLK, read_addr, block_select, read_data_out,
	bp_write_request, bp_write_done, bp_write_addr, bp_write_data);

input SYSCLK;
input [9:1] read_addr;
input block_select;
output [15:0] read_data_out;

input [9:0] bp_write_addr;
input [7:0] bp_write_data;
input bp_write_request;
output bp_write_done;

wire write_request_hi, write_request_lo;
wire write_done_hi,    write_done_lo;

rxramblock ramblk_hi (SYSCLK, read_addr, block_select, read_data_out[15:8],
	write_request_hi, write_done_hi, bp_write_addr[9:1], bp_write_data);

rxramblock ramblk_lo (SYSCLK, read_addr, block_select, read_data_out[7:0],
	write_request_lo, write_done_lo, bp_write_addr[9:1], bp_write_data);

assign write_request_hi = bp_write_request && !bp_write_addr[0];
assign write_request_lo = bp_write_request &&  bp_write_addr[0];

assign bp_write_done = write_done_hi | write_done_lo;

endmodule
