#include "types.h"
#include "ctype.h"
#include "stdio.h"
#include "rt11ffs.h"
#include "memstruct.h"

extern int blocks_in_buffer;
extern int lines_in_buffer;
extern char *text_endp;

ascii_upload()
{
	char *textp;
	int linecnt, charcnt;
	int ch;

	printf("\r\nYou can now upload, paste or type in your text file.\r\n");
	printf("End with Control-D or Control-Z on a line by itself.\r\n\r\n");
	textp = (char *)BUFFER_BASE;
	linecnt = charcnt = 0;

	for (;;) {
		ch = toascii(getchar());
		switch (ch) {
		case '\0':	/* ignore NULs */
			continue;
		case 0x04:	/* ^D */
		case 0x1A:	/* ^Z */
			if (charcnt) {
				putchar(0x07);
				continue;
			} else
				goto eof;
		case 0x08:	/* BS */
		case 0x7F:	/* DEL */
			if (!charcnt)
				continue;
			printf("\b \b");
			textp--;
			charcnt--;
			continue;
		case '\r':	/* CR */
			printf("\r\n");
			if (linecnt >= MAX_LINES) {
				printf("Line count limit exceeded\r\n");
				return(-1);
			}
			*textp++ = '\n';
			linecnt++;
			charcnt = 0;
			continue;
		case 0x15:	/* ^U */
			printf("^U\r\n");
			textp -= charcnt;
			charcnt = 0;
			continue;
		}
		if (iscntrl(ch) || charcnt == MAX_LINE_LEN) {
			putchar(0x07);
			continue;
		}
		putchar(ch);
		*textp++ = ch;
		charcnt++;
	}
eof:	if (!linecnt) {
		printf("Nothing uploaded\r\n");
		return(-1);
	}
	text_endp = textp;
	lines_in_buffer = linecnt;
	return(0);
}

ascii_zeropad()
{
	u_long textlen;

	textlen = text_endp - (char *)BUFFER_BASE;
	blocks_in_buffer = textlen / RT11FFS_AU_SIZE;
	if (textlen & (RT11FFS_AU_SIZE-1)) {
		blocks_in_buffer++;
		bzero(text_endp, blocks_in_buffer * RT11FFS_AU_SIZE - textlen);
	}
	printf("\r\nThe uploaded ASCII text file will occupy %d RT11FFS block%s\r\n", blocks_in_buffer, blocks_in_buffer != 1 ? "s" : "");
	return(0);
}
