#include <sys/param.h>
#include <sys/file.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>

struct rt11ffs_dirent {
	u_short	filename[3];
	u_short	size_flags;
};

struct rt11ffs_dirent segment_header;
u_char rt11ffs_signature[6] = {0x73, 0xBF, 0xC1, 0xC0, 0x26, 0x83};
u_long segment_size;
u_char *segbuf;

int imagefd;
int startsegs, finalsegs;

main(argc, argv)
	char **argv;
{
	char *cp;
	int i;

	if (argc != 4) {
usage:		fprintf(stderr, "usage: %s ffsimage erase_blk_size numsegs\n",
			argv[0]);
		exit(1);
	}

	imagefd = open(argv[1], O_RDWR);
	if (imagefd < 0) {
		perror(argv[1]);
		exit(1);
	}

	segment_size = strtoul(argv[2], &cp, 0);
	if (*cp)
		goto usage;
	if (!ispowerof2(segment_size) || segment_size < 0x4000 ||
	    segment_size > 0x01000000) {
		fprintf(stderr, "%s: %lu is not a valid segment size\n",
			argv[0], segment_size);
		exit(1);
	}
	segbuf = (u_char *)malloc(segment_size);
	if (!segbuf) {
		perror("malloc");
		exit(1);
	}
	bcopy(rt11ffs_signature, segment_header.filename, 6);
	segment_header.size_flags = htons(segment_size >> 9);
	memset(segbuf, 0xFF, segment_size);
	bcopy(&segment_header, segbuf, sizeof segment_header);

	if (get_startsegs() < 0) {
		fprintf(stderr,
	"%s: starting file size is not a multiple of the segment size\n",
			argv[1]);
		exit(1);
	}
	finalsegs = atoi(argv[3]);

	lseek(imagefd, startsegs * segment_size, 0);
	for (i = startsegs; i < finalsegs; i++)
		write(imagefd, segbuf, segment_size);
	exit(0);
}

get_startsegs()
{
	struct stat st;

	fstat(imagefd, &st);
	if (st.st_size % segment_size)
		return(-1);
	startsegs = st.st_size / segment_size;
	return(0);
}

ispowerof2(n)
	u_long n;
{
	return(count1s(n) == 1);
}

count1s(n)
	u_long n;
{
	int c = 0;
	u_long mask;

	for (mask = 1; mask; mask <<= 1)
		if (n & mask)
			c++;
	return(c);
}
