#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>

#define	RT11FFS_AU_SIZE		0x200

int total_blocks;

main(argc, argv)
	char **argv;
{
	char *cp;
	char **ap;

	if (argc < 2) {
usage:		fprintf(stderr, "usage: %s files...\n", argv[0]);
		exit(1);
	}
	for (ap = argv + 1; *ap; ap++)
		add_file(*ap);
	printf("Total RT11FFS blocks: %d\n", total_blocks);
	exit(0);
}

add_file(pathname)
	char *pathname;
{
	struct stat st;
	int nblocks;

	if (stat(pathname, &st) < 0) {
		perror(pathname);
		exit(1);
	}
	nblocks = (st.st_size + 0x1FF) >> 9;
	total_blocks += nblocks;
}
