#include "../libc/types.h"
#include "../lib8973/typedefs.h"
#include "../lib8973/bitpump.h"
#include "state.h"
#include "privstate.h"
#include "miscmac.h"

extern int default_cnxab_response();
extern u_short etsi_noise_margin_table[];

sdcore_init_state(st, pstbuf)
	struct sdcore_state *st;
	caddr_t pstbuf;
{
	struct privstate *pst;

	pst = (struct privstate *) pstbuf;
	bzero(st, sizeof(struct sdcore_state));
	bzero(pst, sizeof(struct privstate));
	st->privstate = (caddr_t) pst;

	/* defaults */
	st->user_data_rate = 98;	/* 784 kbps */
	st->quat_orient = _SERIAL_SIGNFIRST;
	st->cnxab_response = default_cnxab_response;
	st->noise_table = etsi_noise_margin_table;
	st->lost_time = 40;
	st->tempenv_num_intervals = 3;
	st->status.byte = INIT_STATUS_REG;

	return(0);
}
