/*
 * This data structure is used throughout SDCORE and the pointer to it
 * is passed down the call tree like the bitpump # in ZipWire.
 * It represents all state of the SDSL core like the RAM variables did
 * in ZipWire.
 *
 * This structure is visible to SDCORE's clients; there is also a
 * private state structure intended for SDCORE alone.
 */

struct sdcore_state {
	caddr_t	privstate;
	u_short	terminal_type;
	u_short	user_data_rate;		/* in 8 kbps increments */
	u_short	special_modes;
	u_char	quat_orient;
	u_char	preact_type;
	u_short	*noise_table;
	u_char	lost_time;		/* in 100 ms increments */
	union {
		u_char	byte;
		struct {
			u_char	normal_operation:1;
			u_char	four_level_indication:1;
			u_char	run_lost_timer:1;
			u_char	preact_done:1;	/* was nmr_ok */
			u_char	activation_interval:1;
			u_char	tip_ring_indication:1;
			u_char	lost:1;
			u_char	los:1;
		} bits;
	}	status;
	u_char	tempenv_num_intervals;
	char	txgain_setting;
	void	(*htur_su_critsect)();
	u_short	tempenv_critsect_irqmask;
	u_char	cnxab_htuc_flavor[2];
	int	(*cnxab_response)();
	u_char	cnxab_htur_flavor[2];
	u_char	preact_fallback;
};

/* Mode bits in the special_modes field */
#define	SDCORE_MODE_EXTS0S1		0x8000
#define	SDCORE_MODE_NORXDESCRAM		0x4000
#define	SDCORE_MODE_NOAUTOTR		0x2000
#define	SDCORE_MODE_NLECON		0x1000
#define	SDCORE_MODE_TXGAIN_OVERRIDE	0x0800
#define	SDCORE_MODE_HTUC_EXTRADELAYS	0x0400
#define	SDCORE_MODE_AB_CNX_IFCTF	0x0200

/* Pre-activation types */
#define	PREACT_TYPE_NONE	0
#define	PREACT_TYPE_CM		1
#define	PREACT_TYPE_AUTOBAUD	2
#define	PREACT_TYPE_IFCTF	3
