#include "../libc/types.h"
#include "../lib8973/typedefs.h"
#include "../lib8973/config.h"
#include "../lib8973/bitpump.h"
#include "../lib8973/util.h"
#include "state.h"
#include "privstate.h"
#include "suutil.h"

#define NOISE_MARGIN_DB(x)       ((x) - 32)

/***********************************************************/
/*    _ReadNmr()                                           */
/*    Read Noise meter value                               */
/*                                                         */
/*    returns: BP_U_8BIT NMR value (dB)                    */
/*                                                         */
/*    Input variables: BP_U_8BIT no                        */
/*                                                         */
/*    Output variables: None                               */
/*                                                         */
/*    example:                                             */
/*           value = _ReadNmr(no);                         */
/*                                                         */
/* Programmer:                                             */
/*     Iris Shuker                20-Feb-1996              */
/*                                                         */
/* revision history:                                       */
/*                                                         */
/***********************************************************/

BP_S_8BIT
_ReadNmr(st)
    struct sdcore_state *st;
{
    DECLARE_PST;
    DECLARE_PTR;
    BP_S_16BIT value, p_value;
    BP_S_8BIT temp;
    BP_U_8BIT meter;

    NORM(meter); /* Normlize to meter timer value */
    READ_METER_REG(nlm_low, nlm_high, value, meter);

    if (st->status.bits.los) /* LOS of signal */
	value = 1000;
    else {
	if (pst->terminal_type == _HTUC) {
		if (!_IsFirstEyeOpen())
			value = 1000;
        } else {	/* HTU-R */
		/* Check to see if PLL is free running */
		READ_METER_REG(vcxo_frequency_low, vcxo_frequency_high,
				p_value, 0);
		if ( p_value >= MAX_PLL_VALUE || p_value <= -MAX_PLL_VALUE )
			value = 1000;
	} /* End else HTUR */
    } /* End else */
    temp = _LookUpTable(st->noise_table, value);
    temp = NOISE_MARGIN_DB(temp);

    return (temp);

} /* End _ReadNmr() */
