/*
 * This is the internal private state structure for SDCORE; a pointer
 * to this structure lives in the public struct sdcore_state.
 *
 * Clients of SDCORE should *never* include this header file or attempt
 * to access this structure in any way; we want to be able to change it
 * freely without affecting API or ABI compatibility.
 */

#include "../libpreact/abrecv_data.h"
#include "../libpreact/paste.h"

#define	NPHASES	16

struct privstate {
	u_short	terminal_type;
	u_char	stage;
	u_char	stage2;
	u_short	phase_quality[NPHASES];
	u_short	noise_quality[NPHASES];
	union {
		u_char	byte;
		struct {
			u_char	ffe_init_scale:3; /* only 2 bits for now */
			u_char	ffe_data_scale:2; /* only 1 bit for now */
			u_char	reserved:2;
			u_char	adjusted_felm:1;
		} bits;
	}	su_flags;
	u_char	misc_counter;
	u_char	high_felm_threshold;	/* for passing to _SetMeterTimer */
	u_char	low_felm_threshold;	/* ditto */
	u_char	freq_cell;		/* for HTU-R */
	u_char	open_attempts;		/* ditto */
	struct	paste_workbuf paste;	/* preact signal transmission */
	struct	abrecv_workbuf abrecv;	/* AutoBaud receiver */
	u_long	scratch_long;
};

#define	DECLARE_PST	struct privstate *pst = (struct privstate *) st->privstate
