#include "types.h"
#include "stdio.h"
#include "mc68302.h"
#include "gpio.h"

extern volatile struct mc68302_regs mc68302_regs;

show_mctl()
{
	printf("DTR is %s\r\n", mc68302_regs.pbdat & PORTB_DTR ?
		"asserted" : "negated");
	printf("DSR is %s\r\n", mc68302_regs.pbdat & PORTB_DSR ?
		"asserted" : "negated");
	printf("CD is %s\r\n", mc68302_regs.pbdat & PORTB_CD ?
		"asserted" : "negated");
	printf("RTS is %s\r\n", mc68302_regs.pbdat & PORTB_RTS ?
		"asserted" : "negated");
	printf("CTS is %s\r\n", mc68302_regs.pbdat & PORTB_CTS ?
		"asserted" : "negated");
	return(0);
}

toggle_mctl(mask, signame)
	u_short mask;
	char *signame;
{
	char *newstate;

	if (mc68302_regs.pbdat & mask) {
		mc68302_regs.pbdat &= ~mask;
		newstate = "OFF";
	} else {
		mc68302_regs.pbdat |= mask;
		newstate = "ON";
	}
	printf("%s flipped %s\r\n", signame, newstate);
	return(0);
}
