/*
 * Miscellaneous utility functions
 */

#include "types.h"
#include "ctype.h"
#include "stdio.h"
#include "strings.h"

print_timeint(heading, interval)
	char *heading;
	u_long interval;
{
	int days, hours, mins;
	char days_str[16], hours_str[16];

	mins = interval / (20*60);
	days = mins / (24*60);
	mins -= days * 24 * 60;
	hours = mins / 60;
	mins -= hours * 60;
	if (days)
		sprintf(days_str, "%d day%s, ", days, days > 1 ? "s" : "");
	else
		days_str[0] = '\0';
	if (days || hours)
		sprintf(hours_str, "%d hour%s, ", hours, hours != 1 ? "s" : "");
	else
		hours_str[0] = '\0';
	printf("%s: %s%s%d min\r\n", heading, days_str, hours_str, mins);
}
