/*
 * SHOW subcommand dispatch
 */

#include "types.h"
#include "ctype.h"
#include "stdio.h"
#include "strings.h"
#include "craftcmd.h"

#define	MAX_SUBCMDS	16
struct craftcmd show_subcmd_table[MAX_SUBCMDS+1];
struct craftcmd *show_subcmd_table_endp;

void
cmd_show(cmd)
	char *cmd;
{
	char *cp, *np;
	struct craftcmd *ctp;

	for (cp = cmd; isspace(*cp); cp++)
		;
	if (!*cp) {
		printf("SHOW command: argument required; see HELP\r\n");
		return;
	}
	for (np = cp; *cp && !isspace(*cp); cp++)
		;
	if (*cp)
		*cp++ = '\0';
	for (ctp = show_subcmd_table; ctp < show_subcmd_table_endp; ctp++)
		if (craftcmd_cmpfunc(ctp->word, np, ctp->min))
			break;
	if (ctp->func)
		ctp->func(cp);
	else
		printf("SHOW command: invalid argument; see HELP\r\n");
}

register_show_subcmd(cmdname, min, func)
	char *cmdname;
	int min;
	void (*func)();
{
	if (show_subcmd_table_endp - show_subcmd_table >= MAX_SUBCMDS) {
		printf("OPCORE error: trying to register too many SHOW subcommands\r\n");
		return(-1);
	}
	show_subcmd_table_endp->word = cmdname;
	show_subcmd_table_endp->min = min;
	show_subcmd_table_endp->func = func;
	show_subcmd_table_endp++;
	return(0);
}

init_show_subcmd_table()
{
	bzero(show_subcmd_table, sizeof show_subcmd_table);
	show_subcmd_table_endp = show_subcmd_table;
	return(0);
}
