/*
 * This code sets SCC2 up to act as a software data link independent of SDSL.
 */

#include "types.h"
#include "stdio.h"
#include "ctype.h"
#include "strings.h"
#include "mc68302.h"
#include "gpio.h"
#include "monitor_api.h"

extern volatile struct mc68302_regs mc68302_regs;

extern char *config_search();

setup_scc2()
{
	char *s;
	int div114, div115;
	u_short porta;

	porta = mc68302_regs.padat;
	porta &= ~PORTA_DCEMUX_MASK;
	porta |= PORTA_DCEMUX_SCC2;
	porta &= ~PORTA_114MUX_MASK;
	porta &= ~PORTA_115MUX_MASK;
	s = config_search("ccitt_114");
	if (!s) {
		monapi_error("Required parameter ccitt_114= is missing");
		return(-1);
	}
	if (!strcasecmp(s, "BCLK")) {
		porta |= PORTA_114MUX_BCLK180;
		div114 = 0;
	} else if (s[0] == '/' && is_string_num(s+1)) {
		div114 = atoi(s+1);
		if (div114 < 3 || div114 > 2048) {
			monapi_error("ccitt_114=%s: divisor out of range", s);
			return(-1);
		}
		mc68302_regs.scc1.scon = 0x3000 | ((div114 - 1) << 1);
		porta |= PORTA_114MUX_SWCLOCK;
	} else {
		monapi_error("ccitt_114=%s: invalid setting", s);
		return(-1);
	}
	s = config_search("ccitt_115");
	if (!s) {
		monapi_error("Required parameter ccitt_115= is missing");
		return(-1);
	}
	if (!strcasecmp(s, "BCLK"))
		porta |= PORTA_115MUX_BCLK180;
	else if (s[0] == '/' && is_string_num(s+1)) {
		div115 = atoi(s+1);
		if (div115 < 3 || div115 > 2048) {
			monapi_error("ccitt_115=%s: divisor out of range", s);
			return(-1);
		}
		if (div114 && div114 != div115) {
			monapi_error("This hardware doesn't support different divisors for 114 and 115");
			return(-1);
		}
		mc68302_regs.scc1.scon = 0x3000 | ((div115 - 1) << 1);
		porta |= PORTA_115MUX_SWCLOCK;
	} else {
		monapi_error("ccitt_115=%s: invalid setting", s);
		return(-1);
	}
	mc68302_regs.padat = porta;
	return(0);
}
