/*
 * OPCORE's "main" variables and init function
 */

#include "types.h"
#include "stdio.h"
#include "ctype.h"
#include "strings.h"
#include "../sdcore/api.h"
#include "../sdcore/state.h"

#define	HLP_DEFEXT		0x33F0

struct sdcore_api *sdcore_api;
struct sdcore_state *sdcore_state;

u_short help_filename[3];
char appname[7];

opcore_init(appname_rad50, sdap, sdst)
	u_short *appname_rad50;
	struct sdcore_api *sdap;
	struct sdcore_state *sdst;
{
	char *cp;
	int i;

	rad50_word_to_ascii(appname_rad50[0], appname);
	rad50_word_to_ascii(appname_rad50[1], appname + 3);
	cp = appname + 6;
	while (cp > appname && cp[-1] == ' ')
		cp--;
	*cp = '\0';
	sdcore_api = sdap;
	sdcore_state = sdst;
	if (sdap->sdcore_magic != SDCORE_MAGIC ||
	    sdap->sdcore_hwtype != SDCORE_HWTYPE ||
	    sdap->sdcore_api_ver != SDCORE_APIVER ||
	    sdap->sizeof_apitable != sizeof(struct sdcore_api) ||
	    sdap->sizeof_state != sizeof(struct sdcore_state)) {
		printf("OPCORE error: SDCORE ABI version mismatch\r\n");
		return(-1);
	}
	help_filename[0] = appname_rad50[0];
	help_filename[1] = appname_rad50[1];
	help_filename[2] = HLP_DEFEXT;
	i = config_init();
	if (i < 0)
		return(i);
	i = craft_init();
	if (i < 0)
		return(i);
	register_standard_commands();
	i = dtrlogic_init();
	if (i < 0)
		return(i);
	get_lltune_params();
	return(0);
}
