/*
 * Standardized DTR handling logic for all VersaDSU apps
 */

#include "types.h"
#include "stdio.h"
#include "ctype.h"
#include "strings.h"
#include "mc68302.h"
#include "gpio.h"
#include "monitor_api.h"

extern volatile struct mc68302_regs mc68302_regs;

static int dtr_override;

init_dtr_override()
{
	char *s;
	int bool;

	s = config_search("obey_dtr");
	if (!s) {
		bool = 1;	/* default to obey */
		goto act;
	}
	bool = parse_boolean_param(s);
	if (bool < 0) {
		monapi_error("obey_dtr=%s: invalid setting", s);
		return(-1);
	}
act:	dtr_override = !bool;
	return(0);
}

cmd_dtrovr(arg)
	char *arg;
{
	char *cp, *np;

	for (cp = arg; isspace(*cp); cp++)
		;
	if (!*cp) {
inv:		printf("Syntax error: ON or OFF keyword required\r\n");
		return;
	}
	for (np = cp; *cp && !isspace(*cp); cp++)
		;
	if (*cp)
		*cp++ = '\0';
	if (!strcasecmp(np, "ON"))
		dtr_override = 1;
	else if (!strcasecmp(np, "OFF"))
		dtr_override = 0;
	else
		goto inv;
}

dtrlogic_init()
{
	register_craft_command("DTROVR", 6, cmd_dtrovr);
	return(init_dtr_override());
}

dtr_check(printon, printoff)
{
	int realstate, effstate;

	realstate = mc68302_regs.pbdat & PORTB_DTR;
	effstate = realstate || dtr_override;
	if (effstate) {
		if (printon) {
			if (realstate)
				printf("DSU: Detected DTR ON\r\n");
			else
				printf("DTR is off but overridden\r\n");
		}
		return(1);
	} else {
		if (printoff)
			printf("DSU: Detected DTR OFF\r\n");
		return(0);
	}
}
