/*
 * This code reads CONFIG.TXT from FFS, calls the libutil function to parse it,
 * and provides access to the parsed set of parameters.
 */

#include "types.h"
#include "stdio.h"
#include "rt11ffs.h"
#include "../libffs/ffsimpl.h"
#include "monitor_api.h"

#define	CONFIG_TXT_MAXLEN	4096
#define	CONFIG_TXT_MAXBLOCKS	(CONFIG_TXT_MAXLEN / RT11FFS_AU_SIZE)
#define	MAX_CONFIG_PARAM	64	/* max # of param=value pairs */

static char config_txt_buf[CONFIG_TXT_MAXLEN] __attribute__ ((aligned (2)));
static char config_parse_buf[(MAX_CONFIG_PARAM + 1) * 8]
	__attribute__ ((aligned (2)));

static const u_short config_txt_filename[3]
	__attribute__ ((section (".rodata")))
	= {0x1526, 0x26EF, 0x80D4};

extern char *textconf_search();

config_init()
{
	struct find_file_results findstruct;
	struct fragment_info *fp;
	int i, fsize;
	char *dp;

	if (monapi_ffsfindwrap(config_txt_filename, &findstruct) < 0)
		return(-1);
	if (findstruct.total_size > CONFIG_TXT_MAXBLOCKS) {
		monapi_error("CONFIG.TXT exceeds maximum size of %u bytes",
				CONFIG_TXT_MAXLEN);
		return(-1);
	}
	dp = config_txt_buf;
	for (fp = findstruct.frags, i = 0; i < findstruct.nfrags; fp++, i++) {
		fsize = fp->nblks * RT11FFS_AU_SIZE;
		bcopy_words(fp->addr, dp, fsize);
		dp += fsize;
	}
	return(parse_textconf(config_txt_buf,
		findstruct.total_size * RT11FFS_AU_SIZE, config_parse_buf,
		sizeof config_parse_buf, "CONFIG.TXT"));
}

char *
config_search(key)
	char *key;
{
	return textconf_search(config_parse_buf, key);
}

config_dump()
{
	textconf_dump(config_parse_buf);
	return(0);
}
