#include "types.h"
#include "stdio.h"
#include "ctype.h"
#include "strings.h"
#include "console.h"
#include "mc68302.h"
#include "gpio.h"

extern volatile struct mc68302_regs mc68302_regs;

static const struct keyword tdat_options[] = {
	{"DCE_TXD", 1, (long) PORTA_TXMUX_DCE},
	{"FPGA", 1, (long) PORTA_TXMUX_FPGA},
	{"INVDCE", 1, (long) PORTA_TXMUX_DCEINV},
	{"INVTXD", 1, (long) PORTA_TXMUX_DCEINV},
	{"SCC1", 1, (long) PORTA_TXMUX_SCC1},
	{"TXD", 1, (long) PORTA_TXMUX_DCE},
	{NULL, 0, -1}};

static const struct keyword dcerxd_options[] = {
	{"FPGA", 1, (long) PORTA_DCEMUX_FPGA},
	{"INVSDSL", 1, (long) PORTA_DCEMUX_SDSLINV},
	{"SCC2", 2, (long) PORTA_DCEMUX_SCC2},
	{"SDSL_RDAT", 2, (long) PORTA_DCEMUX_SDSL},
	{NULL, 0, -1}};

static const struct keyword ccitt114_options[] = {
	{"BCLK", 4, (long) PORTA_114MUX_BCLK},
	{"BCLK180", 5, (long) PORTA_114MUX_BCLK180},
	{"BCLK_180", 5, (long) PORTA_114MUX_BCLK180},
	{"FPGA", 1, (long) PORTA_114MUX_FPGA},
	{"SWCLOCK", 1, (long) PORTA_114MUX_SWCLOCK},
	{NULL, 0, -1}};

static const struct keyword ccitt115_options[] = {
	{"BCLK", 4, (long) PORTA_115MUX_BCLK},
	{"BCLK180", 5, (long) PORTA_115MUX_BCLK180},
	{"BCLK_180", 5, (long) PORTA_115MUX_BCLK180},
	{"FPGA", 1, (long) PORTA_115MUX_FPGA},
	{"SWCLOCK", 1, (long) PORTA_115MUX_SWCLOCK},
	{NULL, 0, -1}};

cmd_mux_tdat(param)
	struct param *param;
{
	int code, ambig = 0;

	code = find_keyword(param->text, param->len, tdat_options, &ambig);
	if (code != -1)
		mc68302_regs.padat = mc68302_regs.padat & ~PORTA_TXMUX_MASK |
					code;
	else {
		if (ambig)
			error("Ambiguous parameter");
		else
			error("Invalid parameter");
	}
	return(0);
}

cmd_mux_dcerxd(param)
	struct param *param;
{
	int code, ambig = 0;

	code = find_keyword(param->text, param->len, dcerxd_options, &ambig);
	if (code != -1)
		mc68302_regs.padat = mc68302_regs.padat & ~PORTA_DCEMUX_MASK |
					code;
	else {
		if (ambig)
			error("Ambiguous parameter");
		else
			error("Invalid parameter");
	}
	return(0);
}

cmd_mux_114(param)
	struct param *param;
{
	int code, ambig = 0;

	code = find_keyword(param->text, param->len, ccitt114_options, &ambig);
	if (code != -1)
		mc68302_regs.padat = mc68302_regs.padat & ~PORTA_114MUX_MASK |
					code;
	else {
		if (ambig)
			error("Ambiguous parameter");
		else
			error("Invalid parameter");
	}
	return(0);
}

cmd_mux_115(param)
	struct param *param;
{
	int code, ambig = 0;

	code = find_keyword(param->text, param->len, ccitt115_options, &ambig);
	if (code != -1)
		mc68302_regs.padat = mc68302_regs.padat & ~PORTA_115MUX_MASK |
					code;
	else {
		if (ambig)
			error("Ambiguous parameter");
		else
			error("Invalid parameter");
	}
	return(0);
}

static const struct keyword mux_subcmds[] = {
	{"114", 3, (long) &cmd_mux_114},
	{"115", 3, (long) &cmd_mux_115},
	{"CCITT114", 8, (long) &cmd_mux_114},
	{"CCITT115", 8, (long) &cmd_mux_115},
	{"CCITT_114", 9, (long) &cmd_mux_114},
	{"CCITT_115", 9, (long) &cmd_mux_115},
	{"DCE_RXD", 1, (long) &cmd_mux_dcerxd},
	{"RXD", 1, (long) &cmd_mux_dcerxd},
	{"SDSL_TDAT", 1, (long) &cmd_mux_tdat},
	{"TDAT", 1, (long) &cmd_mux_tdat},
	{"TX", 1, (long) &cmd_mux_tdat},
	{NULL, 0, -1}};

cmd_mux(cmd)
	char *cmd;
{
	struct param params[2];
	void (*subcmdfunc)();
	int ambigsubcmd;

	if (parse_cmd(cmd, 2, 2, params, NULL, NULL, NULL))
		return(0);
	ambigsubcmd = 0;
	subcmdfunc = (void (*)())
		find_keyword(params[0].text, params[0].len, mux_subcmds,
				&ambigsubcmd);
	if ((long) subcmdfunc != -1)
		(*subcmdfunc)(&params[1]);
	else {
		if (ambigsubcmd)
			error("Ambiguous parameter");
		else
			error("Invalid parameter");
	}
	return(0);
}
